/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.Comment;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.CommentLinesVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityHeaderTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import java.util.Iterator;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL163")
public class NoCommentEntityPortCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private List<Comment> comments;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.context().isSynthesisFile()) {
            this.comments = new CommentLinesVisitor(tree).getComments();
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitEntityHeader(EntityHeaderTree tree) {
        if (tree.portClause() != null) {
            List<InterfaceDeclarationTree> declarations = tree.portClause().ports().interfaces();
            for (InterfaceDeclarationTree declaration : declarations) {
                this.checkForIssues(declaration);
            }
        }
        super.visitEntityHeader(tree);
    }

    private void checkForIssues(InterfaceDeclarationTree declaration) {
        if (!this.trailingCommentFound(declaration) && !this.commentOnPreviousLineFound(declaration)) {
            this.reportIssue(declaration);
        }
    }

    private boolean trailingCommentFound(VhdlTree declaration) {
        ContiguousSet<Integer> declarationLines = ContiguousSet.create(Range.closed(declaration.firstToken().line(), declaration.lastToken().endLine()), DiscreteDomain.integers());
        for (Comment comment : this.comments) {
            if (comment.isBlank()) continue;
            Iterator iterator2 = declarationLines.iterator();
            while (iterator2.hasNext()) {
                int declarationLine = (Integer)iterator2.next();
                if (!comment.getLineNumbers().contains(declarationLine)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean commentOnPreviousLineFound(VhdlTree declaration) {
        for (Comment comment : this.comments) {
            if (comment.isBlank() || comment.isTrailing() || !comment.getLineNumbers().contains(declaration.firstToken().line() - 1)) continue;
            return true;
        }
        return false;
    }

    private void reportIssue(InterfaceDeclarationTree declaration) {
        for (IdentifierTree identifier : declaration.identifiers()) {
            this.addPreciseIssue(identifier, "Add a comment to this entity port.");
        }
    }
}

