/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.BlankLines;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.Comment;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.CommentLinesVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL207")
public class NoCommentProcessCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck,
CharsetAwareVisitor {
    private Set<Integer> actualCommentLines;
    private Set<Integer> blankButNotTrailingCommentLines;
    private Set<Integer> blankLines;
    private Charset charset;

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        List<Comment> comments = new CommentLinesVisitor(tree).getComments();
        this.actualCommentLines = comments.stream().filter(c -> !c.isTrailing() && !c.isBlank()).map(Comment::getLineNumbers).flatMap(Collection::stream).collect(Collectors.toSet());
        this.blankButNotTrailingCommentLines = comments.stream().filter(c -> !c.isTrailing() && c.isBlank()).map(Comment::getLineNumbers).flatMap(Collection::stream).collect(Collectors.toSet());
        this.blankLines = BlankLines.getBlankLinesFromFile(this.context().file(), this.charset);
        super.visitDesignFile(tree);
    }

    @Override
    public void visitProcessStatement(ProcessStatementTree tree) {
        this.checkForIssues(tree);
        super.visitProcessStatement(tree);
    }

    private void checkForIssues(ProcessStatementTree tree) {
        if (!this.commentOnPreviousLineFound(tree)) {
            this.addPreciseIssue(tree.beginStatementKeyword(), "Add a comment to this process.");
        }
    }

    private boolean commentOnPreviousLineFound(VhdlTree tree) {
        int expectedCommentLine = tree.firstToken().line() - 1;
        while (true) {
            if (this.actualCommentLines.contains(expectedCommentLine)) {
                return true;
            }
            if (!this.blankButNotTrailingCommentLines.contains(expectedCommentLine) && !this.blankLines.contains(expectedCommentLine)) break;
            --expectedCommentLine;
        }
        return false;
    }
}

