/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitorOnSynthesisFileCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SimpleNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL029")
public class NoRangeForIntegerNaturalPositiveCheck
extends DoubleDispatchVisitorOnSynthesisFileCheck
implements FreeHdlDesignerCheck {
    private static final boolean DEFAULT_EXCLUDE_GENERICS = false;
    @RuleProperty(key="excludeGenerics", description="Set to 'true' to not apply this rule on generics, set to 'false' otherwise.", defaultValue="false")
    public boolean excludeGenerics = false;

    @Override
    public void visitSubtypeIndication(SubtypeIndicationTree tree) {
        if (tree.typeName().kind() == VhdlTree.Kind.SIMPLE_NAME) {
            IdentifierTree idTree = ((SimpleNameTree)tree.typeName()).identifier();
            if (!(!Set.of("integer", "natural", "positive").contains(idTree.text().toLowerCase()) || tree.constraint() != null || tree.hasAncestor(VhdlTree.Kind.CONSTANT_DECLARATION) || tree.hasAncestor(VhdlTree.Kind.INTERFACE_CONSTANT_DECLARATION) || tree.hasAncestor(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_FUNCTION) || this.excludeGenerics && tree.hasAncestor(VhdlTree.Kind.GENERIC_CLAUSE))) {
                this.addPreciseIssue(idTree, "Add \"range\" constraint to this " + idTree.text().toLowerCase() + " declaration.");
            }
        }
        super.visitSubtypeIndication(tree);
    }
}

