/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL218")
public class OneEntityPerFileCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private List<EntityDeclarationTree> entities;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.entities = new ArrayList<EntityDeclarationTree>();
        super.visitDesignFile(tree);
        if (this.entities.size() > 1) {
            ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
            for (int i = 1; i < this.entities.size(); ++i) {
                secondaryLocations.add(new HdlIssueLocation(this.entities.get(i).beginEntityKeyword(), "Entity declaration"));
            }
            this.addPreciseIssue(this.entities.get(0).beginEntityKeyword(), "Only define one single entity per file.", secondaryLocations);
        }
    }

    @Override
    public void visitEntityDeclaration(EntityDeclarationTree tree) {
        this.entities.add(tree);
        super.visitEntityDeclaration(tree);
    }
}

