/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.visitors.CrossFileCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.PackageBodyTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.PackageTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.PackageBodyTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.PackageTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL200")
public class PackageBodySameFileAsPackageCheck
extends VhdlDoubleDispatchVisitorCheck
implements CrossFileCheck,
PackageTreeFileAwareVisitor,
PackageBodyTreeFileAwareVisitor {
    private Map<String, Set<PackageTreeFile>> packages = new HashMap<String, Set<PackageTreeFile>>();
    private Map<String, Set<PackageBodyTreeFile>> packageBodies = new HashMap<String, Set<PackageBodyTreeFile>>();

    @Override
    public void setPackages(Set<PackageTreeFile> packages) {
        this.packages = packages.stream().collect(Collectors.groupingBy(t -> ((PackageDeclarationTree)t.tree()).identifier().text(), Collectors.toSet()));
    }

    @Override
    public void setPackageBodies(Set<PackageBodyTreeFile> packageBodies) {
        this.packageBodies = packageBodies.stream().collect(Collectors.groupingBy(t -> ((PackageBodyTree)t.tree()).identifier().text(), Collectors.toSet()));
    }

    @Override
    public final void checkForIssues() {
        for (Map.Entry<String, Set<PackageBodyTreeFile>> entry : this.packageBodies.entrySet()) {
            if (this.packages.get(entry.getKey()) == null) continue;
            PackageTreeFile relatedPackage = (PackageTreeFile)this.packages.get(entry.getKey()).stream().sorted(new TreeFileComparator()).findFirst().get();
            for (PackageBodyTreeFile packageBody : entry.getValue()) {
                if (packageBody.file().getName().equals(relatedPackage.file().getName())) continue;
                this.addPreciseIssue(packageBody.file(), ((PackageBodyTree)packageBody.tree()).packageKeyword(), "Move this package implementation to the file containing its declaration.", List.of(new HdlIssueLocation(relatedPackage.file(), ((PackageDeclarationTree)relatedPackage.tree()).beginPackageKeyword(), "Related package declaration")));
            }
        }
    }
}

