/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSubscriptionVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.BlockTree;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL189")
public class RepeatBlockIdentifierAtEndCheck
extends VhdlSubscriptionVisitorCheck
implements HdlDesignerCheck {
    private static final boolean DEFAULT_PARAMETER_VALUE = true;
    @RuleProperty(key="checkBlocks", description="Set to 'true' to check blocks. Set to 'false' otherwise.", defaultValue="true")
    public boolean checkBlocks = true;
    @RuleProperty(key="checkComponentDeclarations", description="Set to 'true' to check component declarations. Set to 'false' otherwise.", defaultValue="true")
    public boolean checkComponentDeclarations = true;
    @RuleProperty(key="checkContextDeclarations", description="Set to 'true' to check context declarations. Set to 'false' otherwise.", defaultValue="true")
    public boolean checkContextDeclarations = true;
    @RuleProperty(key="checkConfigurationDeclarations", description="Set to 'true' to check configuration declarations. Set to 'false' otherwise.", defaultValue="true")
    public boolean checkConfigurationDeclarations = true;
    @RuleProperty(key="checkPackageDeclarations", description="Set to 'true' to check package declarations. Set to 'false' otherwise.", defaultValue="true")
    public boolean checkPackageDeclarations = true;
    @RuleProperty(key="checkPackageBodies", description="Set to 'true' to check package bodies. Set to 'false' otherwise.", defaultValue="true")
    public boolean checkPackageBodies = true;
    @RuleProperty(key="checkEntityDeclarations", description="Set to 'true' to check entity declarations. Set to 'false' otherwise.", defaultValue="true")
    public boolean checkEntityDeclarations = true;
    @RuleProperty(key="checkArchitectureDeclarations", description="Set to 'true' to check architecture declarations. Set to 'false' otherwise.", defaultValue="true")
    public boolean checkArchitectureDeclarations = true;

    @Override
    public Set<VhdlTree.Kind> nodesToVisit() {
        return VhdlTree.Kind.subkindsOf(BlockTree.class);
    }

    @Override
    public void visitNode(VhdlTree tree) {
        BlockTree block = (BlockTree)tree;
        this.checkMissingEndIdentifier(block);
        this.checkBeginAndEndIdentifiersMatch(block);
    }

    private void checkMissingEndIdentifier(BlockTree tree) {
        if (this.shouldRunCheck(tree) && tree.endIdentifier() == null) {
            this.addPreciseIssue(tree.endKeyword(), "Repeat block identifier at the end.", List.of(new HdlIssueLocation(tree.identifier(), "Begin block identifier")));
        }
    }

    private void checkBeginAndEndIdentifiersMatch(BlockTree tree) {
        if (tree.endIdentifier() != null && !tree.endIdentifier().text().equals(tree.identifier().text())) {
            this.addPreciseIssue(tree.endIdentifier(), String.format("Rename end block identifier \"%s\" to match begin block identifier \"%s\".", tree.endIdentifier().text(), tree.identifier().text()), List.of(new HdlIssueLocation(tree.identifier(), "Begin block identifier")));
        }
    }

    private boolean shouldRunCheck(BlockTree tree) {
        return tree.is(VhdlTree.Kind.BLOCK_STATEMENT) && this.checkBlocks || tree.is(VhdlTree.Kind.COMPONENT_DECLARATION) && this.checkComponentDeclarations || tree.is(VhdlTree.Kind.CONTEXT_DECLARATION) && this.checkContextDeclarations || tree.is(VhdlTree.Kind.CONFIGURATION_DECLARATION) && this.checkConfigurationDeclarations || tree.is(VhdlTree.Kind.PACKAGE_DECLARATION) && this.checkPackageDeclarations || tree.is(VhdlTree.Kind.PACKAGE_BODY) && this.checkPackageBodies || tree.is(VhdlTree.Kind.ENTITY_DECLARATION) && this.checkEntityDeclarations || tree.is(VhdlTree.Kind.ARCHITECTURE_BODY) && this.checkArchitectureDeclarations;
    }
}

