/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL319")
public class ReservedWordFutureStandardCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final Set<String> vhdl1993 = Set.of();
    private static final Set<String> vhdl2002 = Set.of("procedural", "protected", "reference");
    private static final Set<String> vhdl2008 = Set.of("assume", "assume_guarantee", "context", "cover", "fairness", "force", "parameter", "property", "protected", "release", "restrict", "restrict_guarantee", "sequence", "strong");
    private static final Set<String> vhdl2019 = Set.of("assume", "context", "cover", "default", "fairness", "force", "parameter", "property", "protected", "private", "release", "restrict", "sequence", "strong", "view", "vpkg", "vmode", "vprop", "vunit");

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        HashSet<String> versions = new HashSet<String>();
        if (vhdl1993.contains(tree.text().toLowerCase())) {
            versions.add("VHDL 1993");
        }
        if (vhdl2002.contains(tree.text().toLowerCase())) {
            versions.add("VHDL 2002");
        }
        if (vhdl2008.contains(tree.text().toLowerCase())) {
            versions.add("VHDL 2008");
        }
        if (vhdl2019.contains(tree.text().toLowerCase())) {
            versions.add("VHDL 2019");
        }
        if (!versions.isEmpty()) {
            this.addPreciseIssue(tree.identifier(), String.format("Rename this identifier as \"%s\" is a reserved word in %s.", tree.identifier().text(), versions.stream().sorted().collect(Collectors.joining(", "))));
        }
        super.visitIdentifier(tree);
    }
}

