/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VHDL314")
public class SuperfluousTrueFalseCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final Set<String> TRUE_FALSE = Set.of("true", "false");
    private static final Set<String> OPERATORS = Set.of("=", "/=", "and", "or", "not", "nor", "xor", "xnor", "nand");

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        List<VhdlSyntaxToken> tokens = tree.allChildren(VhdlTree.Kind.TOKEN).stream().map(t -> (VhdlSyntaxToken)t).toList();
        for (int i = 1; i < tokens.size(); ++i) {
            if (!TRUE_FALSE.contains(tokens.get(i).text().toLowerCase()) || !OPERATORS.contains(tokens.get(i - 1).text().toLowerCase())) continue;
            this.addPreciseIssue(tokens.get(i), String.format("Remove this useless '%s'.", tokens.get(i).text()));
        }
        super.visitDesignFile(tree);
    }
}

