/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VHDL162")
public class SystemVerilogKeywordCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    public static final List<String> SYSTEMVERILOG_KEYWORDS = List.of("always", "and", "assign", "automatic", "begin", "buf", "bufif0", "bufif1", "case", "casex", "casez", "cell", "cmos", "config", "deassign", "default", "defparam", "design", "disable", "edge", "else", "end", "endcase", "endconfig", "endfunction", "endgenerate", "endmodule", "endprimitive", "endspecify", "endtable", "endtask", "event", "for", "force", "forever", "fork", "function", "generate", "genvar", "highz0", "highz1", "if", "ifnone", "incdir", "include", "initial", "inout", "input", "instance", "integer", "interconnect", "join", "large", "liblist", "library", "localparam", "macromodule", "medium", "module", "nand", "negedge", "nmos", "nor", "noshowcancelledno", "not", "notif0", "notif1", "or", "output", "parameter", "pmos", "posedge", "primitive", "pull0", "pull1", "pulldown", "pullup", "pulsestyle_oneventglitch", "pulsestyle_ondetectglitch", "rcmos", "real", "realtime", "reg", "release", "repeat", "rnmos", "rpmos", "rtran", "rtranif0", "rtranif1", "scalared", "showcancelled", "signed", "small", "specify", "specparam", "strong0", "strong1", "supply0", "supply1", "table", "task", "time", "tran", "tranif0", "tranif1", "tri", "tri0", "tri1", "triand", "trior", "trireg", "unsigned", "use", "vectored", "wait", "wand", "weak0", "weak1", "while", "wire", "wor", "xnor", "xor", "accept_on", "alias", "always_comb", "always_ff", "always_latch", "assert", "assume", "before", "bind", "bins", "binsof", "bit", "break", "byte", "chandle", "checker", "class", "clocking", "const", "constraint", "context", "continue", "cover", "covergroup", "coverpoint", "cross", "dist", "do", "endchecker", "endclass", "endclocking", "endgroup", "endinterface", "endpackage", "endprogram", "endproperty", "endsequence", "enum", "eventually", "expect", "export", "extends", "extern", "final", "first_match", "foreach", "forkjoin", "global", "iff", "ignore_bins", "illegal_bins", "implements", "implies", "import", "-incdir", "inside", "int", "interface", "intersect", "join_any", "join_none", "let", "local", "logic", "longint", "matches", "modport", "nettype", "new", "nexttime", "null", "1step", "package", "packed", "priority", "program", "property", "protected", "pure", "rand", "randc", "randcase", "randsequence", "reject_on", "ref", "restrict", "return", "s_always", "s_eventually", "s_nexttime", "s_until", "s_until_with", "sequence", "shortint", "shortreal", "soft", "solve", "static", "string", "strong", "struct", "super", "sync_accept_on", "sync_reject_on", "tagged", "this", "throughout", "timeprecision", "timeunit", "type", "typedef", "union", "unique", "unique0", "until", "until_with", "untypted", "uwire", "var", "virtual", "void", "wait_order", "weak", "wildcard", "with", "within");

    @Override
    public void visitEntityDeclaration(EntityDeclarationTree tree) {
        this.checkForIssue(tree.identifier());
        for (IdentifierTree identifier : tree.allPortIdentifiers()) {
            this.checkForIssue(identifier);
        }
        for (IdentifierTree identifier : tree.genericIdentifiers()) {
            this.checkForIssue(identifier);
        }
        super.visitEntityDeclaration(tree);
    }

    private void checkForIssue(IdentifierTree identifier) {
        if (SYSTEMVERILOG_KEYWORDS.contains(identifier.text().toLowerCase())) {
            this.addPreciseIssue(identifier, "Rename this identifier as it matches a Verilog/SystemVerilog keyword.");
        }
    }
}

