/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.LinesOfCodeVisitor;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationFunctionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationProcedureTree;
import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL228")
public class TooManyLinesOfCodeInFunctionProcedureCheck
extends VhdlDoubleDispatchVisitorCheck
implements HdlDesignerCheck {
    private static final int DEFAULT_MAXIMUM = 100;
    @RuleProperty(key="max", description="Maximum number of lines of code in a function/procedure.", defaultValue="100")
    public int max = 100;

    @Override
    public void visitSubprogramBody(SubprogramBodyTree tree) {
        int lines;
        if (tree.statementPart() != null && (lines = new LinesOfCodeVisitor(tree.statementPart()).getNumberOfLinesOfCode()) > this.max) {
            VhdlInternalSyntaxToken issueLocation = tree.specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_FUNCTION) ? ((SubprogramSpecificationFunctionTree)tree.specification()).functionKeyword() : ((SubprogramSpecificationProcedureTree)tree.specification()).procedureKeyword();
            this.addPreciseIssue(issueLocation, MessageFormat.format("This {0} has {1} lines of code, which is greater than {2} authorized. Split it into smaller {0}s.", tree.specification().humanReadableKind(), lines, this.max));
        }
        super.visitSubprogramBody(tree);
    }
}

