/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.LoopStatementTree;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL172")
public class TooManyNestedConditionCheck
extends VhdlDoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final int DEFAULT_MAX_NESTED_LEVELS = 2;
    private Deque<VhdlTree> conditionalStatements;
    private String issueMessage;
    @RuleProperty(key="maxNestedLevels", description="The maximum number of authorized nested levels. Set to '0' to disallow nested conditional branching statements, '1' to allow one nested level and so on.", defaultValue="2")
    public int maxNestedLevels = 2;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.issueMessage = this.computeIssueMessage();
        this.conditionalStatements = new ArrayDeque<VhdlTree>();
        super.visitDesignFile(tree);
    }

    @Override
    public void visitCaseStatement(CaseStatementTree tree) {
        this.checkNesting(tree);
        this.conditionalStatements.push(tree.firstToken());
        super.visitCaseStatement(tree);
        this.conditionalStatements.pop();
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.checkNesting(tree);
        this.conditionalStatements.push(tree.firstToken());
        super.visitIfStatement(tree);
        this.conditionalStatements.pop();
    }

    @Override
    public void visitWhileStatement(LoopStatementTree tree) {
        this.checkNesting(tree);
        this.conditionalStatements.push(tree.firstToken());
        super.visitWhileStatement(tree);
        this.conditionalStatements.pop();
    }

    @Override
    public void visitForStatement(LoopStatementTree tree) {
        this.checkNesting(tree);
        this.conditionalStatements.push(tree.firstToken());
        super.visitForStatement(tree);
        this.conditionalStatements.pop();
    }

    private void checkNesting(VhdlTree tree) {
        int depth = this.conditionalStatements.size();
        if (depth > this.maxNestedLevels) {
            ArrayList<HdlIssueLocation> secondary = new ArrayList<HdlIssueLocation>(depth);
            for (VhdlTree statement : this.conditionalStatements) {
                secondary.add(new HdlIssueLocation(statement, "Conditional branching statement involved in too deeply nesting"));
            }
            this.addPreciseIssue(tree.firstToken(), this.issueMessage, secondary);
        }
    }

    private String computeIssueMessage() {
        StringBuilder message = new StringBuilder("Refactor this code to not nest ");
        if (this.maxNestedLevels == 0) {
            message.append("any conditional branching statement");
        } else {
            message.append("more than ").append(this.maxNestedLevels).append(" conditional branching statement").append(this.maxNestedLevels != 1 ? "s" : "");
        }
        message.append(".");
        return message.toString();
    }
}

