/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.helpers;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssues;
import com.lintyservices.sonar.plugins.hdl.visitors.ConfigAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import org.sonar.api.config.Configuration;

public abstract class VhdlBugFinderCheck
extends VhdlDoubleDispatchVisitorCheck
implements ConfigAwareVisitor {
    private final HdlIssues issues = new HdlIssues(this);
    private Configuration config;

    protected VhdlBugFinderCheck() {
        this.validateCheckParameters();
        this.issues.reset();
    }

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.isBugfinderEnabled() && this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    public void visitFile(DesignFileTree tree) {
        super.visitDesignFile(tree);
    }

    public boolean isBugfinderEnabled() {
        return (Boolean)this.config().getBoolean("sonar.bugfinder.enabled").get();
    }

    @Override
    public HdlIssues issues() {
        return this.issues;
    }

    @Override
    public void setConfig(Configuration config) {
        this.config = config;
    }

    @Override
    public Configuration config() {
        return this.config;
    }
}

