/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.check;

import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.BeginEndLabelTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.util.regex.Pattern;

public abstract class StandardLabelNamingConventionCheck
extends VhdlDoubleDispatchVisitorCheck {
    public static final String SYNTHESIS_FILE_DEFAULT_FORMAT = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    public static final String SIMULATION_FILE_DEFAULT_FORMAT = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    public static final String SYNTHESIS_FILE_FORMAT_PARAMETER_DESCRIPTION = "Regular expression to match for synthesis files.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com";
    public static final String SIMULATION_FILE_FORMAT_PARAMETER_DESCRIPTION = "Regular expression to match for simulation files.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com";
    private Pattern pattern;
    private String format;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.pattern = this.context().isSimulationFile() ? this.computeSimulationPattern() : this.computeSynthesisPattern();
        this.format = this.context().isSimulationFile() ? this.getSimulationFormat() : this.getSynthesisFormat();
        super.visitDesignFile(tree);
    }

    public void checkForIssues(BeginEndLabelTree tree) {
        if (tree.label() != null && !this.pattern.matcher(tree.label().identifier().text()).matches()) {
            this.addPreciseIssue(tree.label().identifier(), "Rename this label to match the following regular expression: " + this.format);
        }
    }

    public abstract String getSynthesisFormat();

    public abstract void setSynthesisFormat(String var1);

    public abstract String getSimulationFormat();

    public abstract void setSimulationFormat(String var1);

    private Pattern computeSynthesisPattern() {
        return this.computePattern(this.getSynthesisFormat());
    }

    private Pattern computeSimulationPattern() {
        return this.computePattern(this.getSimulationFormat());
    }

    private Pattern computePattern(String format) {
        return Pattern.compile(format, 32);
    }
}

