/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.check;

import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlDoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.DeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SingleDeclarationTree;
import com.lintyservices.utils.LintyException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public abstract class StandardNamingConventionCheck
extends VhdlDoubleDispatchVisitorCheck {
    private Pattern pattern;

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.pattern = this.computePattern();
        super.visitDesignFile(tree);
    }

    public void checkForNamingConventionIssue(DeclarationTree tree) {
        ArrayList<IdentifierTree> identifiers = new ArrayList<IdentifierTree>();
        if (tree instanceof SingleDeclarationTree) {
            SingleDeclarationTree t = (SingleDeclarationTree)tree;
            if (t.identifier() != null) {
                identifiers.add(((SingleDeclarationTree)tree).identifier());
            }
        } else if (tree instanceof MultipleDeclarationTree) {
            MultipleDeclarationTree t = (MultipleDeclarationTree)tree;
            identifiers.addAll(t.identifiers());
        } else {
            throw new LintyException("StandardNamingConventionCheck: Unknown DeclarationTree kind");
        }
        for (IdentifierTree identifier : identifiers) {
            if (this.pattern.matcher(identifier.text()).matches()) continue;
            this.addPreciseIssue(identifier, String.format("Rename this %s to match the following regular expression: %s", tree.humanReadableKind(), this.getFormat()));
        }
    }

    public abstract String getFormat();

    public abstract void setFormat(String var1);

    private Pattern computePattern() {
        return Pattern.compile(this.getFormat(), 32);
    }
}

