/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.measures.visitors;

import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSubscriptionVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.measures.metrics.VhdlMetrics;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.CommentLinesVisitor;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.ComplexityVisitor;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.CountArchitecturesVisitor;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.CountComponentsVisitor;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.CountEntitiesVisitor;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.LinesOfCodeVisitor;
import java.io.Serializable;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;

public class VhdlMetricsVisitor
extends VhdlSubscriptionVisitor {
    private final SensorContext sensorContext;
    private final FileSystem fileSystem;
    private InputFile inputFile;

    public VhdlMetricsVisitor(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
        this.fileSystem = sensorContext.fileSystem();
    }

    @Override
    public Set<VhdlTree.Kind> nodesToVisit() {
        return Set.of(VhdlTree.Kind.DESIGN_FILE);
    }

    @Override
    public void visitFile(VhdlTree tree) {
        this.inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(this.context().file()));
    }

    @Override
    public void leaveFile(VhdlTree tree) {
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY, new ComplexityVisitor(this.context().tree()).getComplexity());
        this.saveMetricOnFile(CoreMetrics.COMMENT_LINES, new CommentLinesVisitor(this.context().tree()).getNumberOfCommentLines());
        this.saveMetricOnFile(CoreMetrics.NCLOC, new LinesOfCodeVisitor(this.context().tree()).getNumberOfLinesOfCode());
        this.saveMetricOnFile(VhdlMetrics.ENTITIES, new CountEntitiesVisitor(this.context().tree()).getCount());
        this.saveMetricOnFile(VhdlMetrics.ARCHITECTURES, new CountArchitecturesVisitor(this.context().tree()).getCount());
        this.saveMetricOnFile(VhdlMetrics.COMPONENTS, new CountComponentsVisitor(this.context().tree()).getCount());
    }

    private <T extends Serializable> void saveMetricOnFile(Metric<T> metric, T value) {
        this.sensorContext.newMeasure().forMetric(metric).on((InputComponent)this.inputFile).withValue(value).save();
    }
}

