/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.model;

import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import java.util.Collections;
import java.util.List;

public class InternalSyntaxTrivia
extends TreeImpl
implements SyntaxTrivia {
    private final String comment;
    private final int line;
    private final int column;
    private int endLine;
    private int endColumn;

    public InternalSyntaxTrivia(String comment, int line, int column) {
        super(null);
        this.comment = comment;
        this.line = line;
        this.column = column;
        this.calculateEndOffsets();
    }

    private void calculateEndOffsets() {
        String[] lines = this.comment.split("\r\n|\n|\r", -1);
        this.endColumn = this.column + this.comment.length();
        this.endLine = this.line + lines.length - 1;
        if (this.endLine != this.line) {
            this.endColumn = lines[lines.length - 1].length();
        }
    }

    @Override
    public String text() {
        return this.comment;
    }

    @Override
    public String actualText() {
        String processedText = this.text().replaceAll("^--", "").replaceAll("--$", "").replaceAll("^/\\*", "").replaceAll("\\*/$", "").replace("\r\n", "\n").replace("\r", "\n").trim();
        StringBuilder trimmedText = new StringBuilder();
        for (String l : processedText.split("\n")) {
            trimmedText.append(l.trim()).append("\n");
        }
        return trimmedText.toString().trim();
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int endLine() {
        return this.endLine;
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.TRIVIA;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public VhdlSyntaxToken firstToken() {
        return this;
    }

    @Override
    public VhdlSyntaxToken lastToken() {
        return this;
    }

    @Override
    public List<SyntaxTrivia> trivias() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<VhdlTree> children() {
        return Collections.emptyList();
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitInternalSyntaxTrivia(this);
    }

    public static SyntaxTrivia create(String comment, int startLine, int column) {
        return new InternalSyntaxTrivia(comment, startLine, column);
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public int endColumn() {
        return this.endColumn;
    }
}

