/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.model;

import com.lintyservices.doxygen.Doxygen;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.Comment;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.CommentLinesVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.sslr.grammar.GrammarRuleKey;

public abstract class TreeImpl
implements VhdlTree {
    @Nullable
    private VhdlTree parent;
    protected GrammarRuleKey grammarRuleKey;
    private List<VhdlTree> children;

    protected TreeImpl(GrammarRuleKey grammarRuleKey) {
        this.grammarRuleKey = grammarRuleKey;
    }

    @Override
    @Nullable
    public VhdlSyntaxToken firstToken() {
        for (VhdlTree child : this.getChildren()) {
            VhdlSyntaxToken first = child.firstToken();
            if (first == null) continue;
            return first;
        }
        return null;
    }

    @Override
    @Nullable
    public VhdlSyntaxToken lastToken() {
        List<VhdlTree> trees = this.getChildren();
        for (int index = trees.size() - 1; index >= 0; --index) {
            VhdlSyntaxToken last = trees.get(index).lastToken();
            if (last == null) continue;
            return last;
        }
        return null;
    }

    @Override
    public List<VhdlSyntaxToken> allTokens() {
        return this.allChildren(VhdlTree.Kind.TOKEN).stream().map(VhdlTree::firstToken).toList();
    }

    @Override
    public int numberOfTokens() {
        return this.allChildren(VhdlTree.Kind.TOKEN).size();
    }

    @Override
    public int line() {
        VhdlSyntaxToken firstSyntaxToken = this.firstToken();
        if (firstSyntaxToken == null) {
            return -1;
        }
        return firstSyntaxToken.line();
    }

    @Override
    public int column() {
        VhdlSyntaxToken firstSyntaxToken = this.firstToken();
        if (firstSyntaxToken == null) {
            return -1;
        }
        return firstSyntaxToken.column();
    }

    @Override
    public int endLine() {
        VhdlSyntaxToken lastSyntaxToken = this.lastToken();
        if (lastSyntaxToken == null) {
            return -1;
        }
        return lastSyntaxToken.endLine();
    }

    @Override
    public int endColumn() {
        VhdlSyntaxToken lastSyntaxToken = this.lastToken();
        if (lastSyntaxToken == null) {
            return -1;
        }
        return lastSyntaxToken.endColumn();
    }

    @Override
    public final boolean isOneOf(VhdlTree.Kind ... kinds) {
        return this.isOneOf(Set.of(kinds));
    }

    @Override
    public final boolean isOneOf(Set<VhdlTree.Kind> kinds) {
        return kinds.contains(this.kind());
    }

    @Override
    public final boolean is(VhdlTree.Kind kind) {
        return this.isOneOf(kind);
    }

    @Override
    public VhdlTree parent() {
        return this.parent;
    }

    public void setParent(VhdlTree parent) {
        this.parent = parent;
    }

    @Override
    public boolean hasAncestor(VhdlTree.Kind kind) {
        if (this.parent() != null) {
            if (this.parent().is(kind)) {
                return true;
            }
            return this.parent().hasAncestor(kind);
        }
        return false;
    }

    @Override
    @Nullable
    public VhdlTree ancestor(VhdlTree.Kind kind) {
        if (this.parent() != null) {
            if (this.parent().is(kind)) {
                return this.parent;
            }
            return this.parent().ancestor(kind);
        }
        return null;
    }

    protected abstract Iterable<VhdlTree> children();

    @Override
    public List<VhdlTree> allChildren(VhdlTree.Kind kind) {
        return this.allChildren(Set.of(kind));
    }

    @Override
    public List<VhdlTree> allChildren(Set<VhdlTree.Kind> kinds) {
        return this.allChildren(kinds, Set.of());
    }

    @Override
    public List<VhdlTree> allChildren(Set<VhdlTree.Kind> kinds, Set<VhdlTree.Kind> branchesToExclude) {
        ArrayList<VhdlTree> allChildren = new ArrayList<VhdlTree>();
        this.allChildren(this, kinds, branchesToExclude, allChildren);
        return allChildren;
    }

    private void allChildren(TreeImpl tree, Set<VhdlTree.Kind> kinds, Set<VhdlTree.Kind> branchesToExclude, List<VhdlTree> allChildren) {
        tree.children().forEach(child -> {
            if (child != null) {
                if (child.isOneOf(kinds)) {
                    allChildren.add((VhdlTree)child);
                }
                if (!branchesToExclude.contains(child.kind())) {
                    ((TreeImpl)child).allChildren((TreeImpl)child, kinds, branchesToExclude, allChildren);
                }
            }
        });
    }

    public List<VhdlTree> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<VhdlTree>();
            this.children().forEach(child -> {
                if (child != null) {
                    this.children.add((VhdlTree)child);
                }
            });
        }
        return this.children;
    }

    public boolean isLeaf() {
        return false;
    }

    public GrammarRuleKey getGrammarRuleKey() {
        return this.grammarRuleKey;
    }

    @Override
    public String toString() {
        return this.toString(this, new StringBuilder());
    }

    @Override
    public String toStringWithWhitespaceBetweenEachTree() {
        return this.toStringWithWhitespaceBetweenEachTree(this, new StringBuilder()).trim();
    }

    private String toString(VhdlTree tree, StringBuilder builder) {
        if (tree.is(VhdlTree.Kind.TOKEN)) {
            builder.append(tree.firstToken().text());
        }
        if (!((TreeImpl)tree).isLeaf()) {
            for (VhdlTree value : ((TreeImpl)tree).getChildren()) {
                TreeImpl nextTree = (TreeImpl)value;
                this.toString(nextTree, builder);
            }
        }
        return String.valueOf(builder);
    }

    private String toStringWithWhitespaceBetweenEachTree(VhdlTree tree, StringBuilder builder) {
        if (tree.is(VhdlTree.Kind.TOKEN)) {
            builder.append(tree.firstToken().text()).append(" ");
        }
        if (!((TreeImpl)tree).isLeaf()) {
            for (VhdlTree value : ((TreeImpl)tree).getChildren()) {
                TreeImpl nextTree = (TreeImpl)value;
                this.toStringWithWhitespaceBetweenEachTree(nextTree, builder);
            }
        }
        return String.valueOf(builder);
    }

    @Override
    @Nullable
    public String doxygenComments() {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        VhdlSyntaxToken firstToken = this.firstToken();
        DesignFileTree designFileTree = (DesignFileTree)this.ancestor(VhdlTree.Kind.DESIGN_FILE);
        List<Comment> allFileComments = new CommentLinesVisitor(designFileTree).getComments();
        for (Comment comment : allFileComments) {
            if (!comment.isTrailing() && comment.token().equals(firstToken)) {
                comments.add(comment);
            }
            if (!comment.isTrailing() || !comment.getLineNumbers().contains(firstToken.line())) continue;
            comments.add(comment);
        }
        String doxygenComment = Doxygen.commentsAsHtml(comments.stream().map(c -> c.trivia().text()).toList());
        if (doxygenComment.isBlank()) {
            doxygenComment = null;
        }
        return doxygenComment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VhdlTree)) {
            return false;
        }
        VhdlTree t = (VhdlTree)o;
        return t.kind().equals(this.kind()) && t.line() == this.line() && t.column() == this.column() && t.endLine() == this.endLine() && t.endColumn() == this.endColumn();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.line();
        result = 31 * result + this.column();
        result = 31 * result + this.endLine();
        result = 31 * result + this.endColumn();
        return result;
    }
}

