/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.model;

import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import java.util.Collections;
import java.util.List;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class VhdlInternalSyntaxToken
extends TreeImpl
implements VhdlSyntaxToken {
    private final List<SyntaxTrivia> trivias;
    private final int startIndex;
    private final int endIndex;
    private final int line;
    private final int column;
    private int endLine;
    private int endColumn;
    private final String value;
    private final boolean isEOF;
    private boolean isSynthesized = true;

    public VhdlInternalSyntaxToken(VhdlInternalSyntaxToken internalSyntaxToken) {
        this(internalSyntaxToken.line, internalSyntaxToken.column, internalSyntaxToken.value, internalSyntaxToken.trivias, internalSyntaxToken.startIndex, internalSyntaxToken.endIndex, internalSyntaxToken.isEOF);
    }

    public VhdlInternalSyntaxToken(int line, int column, String value, List<SyntaxTrivia> trivias, int startIndex, int endIndex, boolean isEOF) {
        super(null);
        this.value = value;
        this.line = line;
        this.column = column;
        this.trivias = trivias;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.isEOF = isEOF;
        this.calculateEndOffsets();
    }

    public void setSynthesized(boolean isSynthesized) {
        this.isSynthesized = isSynthesized;
    }

    public boolean isSynthesized() {
        return this.isSynthesized;
    }

    private void calculateEndOffsets() {
        String[] lines = this.value.split("\r\n|\n|\r", -1);
        this.endColumn = this.column + this.value.length();
        this.endLine = this.line + lines.length - 1;
        if (this.endLine != this.line) {
            this.endColumn = lines[lines.length - 1].length();
        }
    }

    public int fromIndex() {
        return this.startIndex;
    }

    @Override
    public VhdlSyntaxToken firstToken() {
        return this;
    }

    @Override
    public VhdlSyntaxToken lastToken() {
        return this;
    }

    @Override
    public String text() {
        return this.value;
    }

    @Override
    public List<SyntaxTrivia> trivias() {
        return this.trivias;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitInternalSyntaxToken(this);
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public int endLine() {
        return this.endLine;
    }

    @Override
    public int endColumn() {
        return this.endColumn;
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.TOKEN;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean isEOF() {
        return this.isEOF;
    }

    @Override
    public Iterable<VhdlTree> children() {
        return Collections.emptyList();
    }

    public void setGrammarRuleKey(GrammarRuleKey grammarRuleKey) {
        this.grammarRuleKey = grammarRuleKey;
    }
}

