/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseStatementAlternativeTree;
import com.lintyservices.sonar.plugins.vhdl.parser.CaseStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ChoiceTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierColonTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class CaseStatementTreeImpl
extends TreeImpl
implements CaseStatementTree {
    @Nullable
    private final IdentifierColonTree label;
    private final VhdlInternalSyntaxToken beginStatementKeyword;
    private final VhdlTree expression;
    private final VhdlInternalSyntaxToken isKeyword;
    private final List<CaseStatementAlternativeTree> alternatives;
    private final VhdlInternalSyntaxToken endKeyword;
    @Nullable
    private final VhdlInternalSyntaxToken endStatementKeyword;
    @Nullable
    private final IdentifierTree endLabel;
    private final VhdlInternalSyntaxToken semicolon;

    public CaseStatementTreeImpl(@Nullable IdentifierColonTree label, VhdlInternalSyntaxToken beginStatementKeyword, VhdlTree expression, VhdlInternalSyntaxToken isKeyword, List<CaseStatementAlternativeTree> alternatives, VhdlInternalSyntaxToken endKeyword, @Nullable VhdlInternalSyntaxToken endStatementKeyword, @Nullable IdentifierTree endLabel, VhdlInternalSyntaxToken semicolon) {
        super(VhdlTree.Kind.CASE_STATEMENT);
        this.label = label;
        this.beginStatementKeyword = beginStatementKeyword;
        this.expression = expression;
        this.isKeyword = isKeyword;
        this.alternatives = alternatives;
        this.endKeyword = endKeyword;
        this.endStatementKeyword = endStatementKeyword;
        this.endLabel = endLabel;
        this.semicolon = semicolon;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitCaseStatement(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.CASE_STATEMENT;
    }

    @Override
    public IdentifierColonTree label() {
        return this.label;
    }

    @Override
    public VhdlInternalSyntaxToken beginStatementKeyword() {
        return this.beginStatementKeyword;
    }

    @Override
    public VhdlInternalSyntaxToken endKeyword() {
        return this.endKeyword;
    }

    @Override
    @Nullable
    public VhdlInternalSyntaxToken endStatementKeyword() {
        return this.endStatementKeyword;
    }

    @Override
    public VhdlTree expression() {
        return this.expression;
    }

    @Override
    public List<CaseStatementAlternativeTree> alternatives() {
        return this.alternatives;
    }

    @Override
    public Map<String, List<ChoiceTree>> allChoices() {
        HashMap<String, List<ChoiceTree>> map = new HashMap<String, List<ChoiceTree>>();
        this.alternatives.forEach(a -> a.choices().choices().forEach(c -> {
            String treeString = c.toString();
            if (map.containsKey(treeString)) {
                ((List)map.get(treeString)).add(c);
            } else {
                ArrayList<ChoiceTree> choices = new ArrayList<ChoiceTree>();
                choices.add((ChoiceTree)c);
                map.put(c.toString(), choices);
            }
        }));
        return map;
    }

    @Override
    public IdentifierTree endLabel() {
        return this.endLabel;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(this.label != null ? Collections.singleton(this.label) : Collections.emptyList(), Collections.singleton(this.beginStatementKeyword), Collections.singleton(this.expression), Collections.singleton(this.isKeyword), this.alternatives, Collections.singleton(this.endKeyword), Collections.singleton(this.endStatementKeyword), this.endLabel != null ? Collections.singleton(this.endLabel) : Collections.emptyList(), Collections.singleton(this.semicolon));
    }
}

