/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.GenericClauseTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortClauseTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ComponentDeclarationTreeImpl
extends TreeImpl
implements ComponentDeclarationTree {
    VhdlInternalSyntaxToken componentKeyword;
    IdentifierTree identifier;
    @Nullable
    VhdlInternalSyntaxToken isKeyword;
    @Nullable
    GenericClauseTree genericClause;
    @Nullable
    PortClauseTree portClause;
    VhdlInternalSyntaxToken endKeyword;
    VhdlInternalSyntaxToken endComponentKeyword;
    @Nullable
    IdentifierTree endIdentifier;
    VhdlInternalSyntaxToken semiPunc;

    public ComponentDeclarationTreeImpl(VhdlInternalSyntaxToken componentKeyword, IdentifierTreeImpl identifier, @Nullable VhdlInternalSyntaxToken isKeyword, GenericClauseTree genericClause, PortClauseTree portClause, VhdlInternalSyntaxToken endKeyword, VhdlInternalSyntaxToken endComponentKeyword, IdentifierTree endIdentifier, VhdlInternalSyntaxToken semiPunc) {
        super(VhdlTree.Kind.COMPONENT_DECLARATION);
        this.componentKeyword = componentKeyword;
        this.identifier = identifier;
        this.isKeyword = isKeyword;
        this.genericClause = genericClause;
        this.portClause = portClause;
        this.endKeyword = endKeyword;
        this.endComponentKeyword = endComponentKeyword;
        this.endIdentifier = endIdentifier;
        this.semiPunc = semiPunc;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitDeclaration(this);
        visitor.visitComponentDeclaration(this);
        visitor.leaveDeclaration(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.COMPONENT_DECLARATION;
    }

    @Override
    public VhdlInternalSyntaxToken componentKeyword() {
        return this.componentKeyword;
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    public GenericClauseTree genericClause() {
        return this.genericClause;
    }

    @Override
    public PortClauseTree portClause() {
        return this.portClause;
    }

    @Override
    public IdentifierTree endIdentifier() {
        return this.endIdentifier;
    }

    @Override
    public VhdlInternalSyntaxToken endKeyword() {
        return this.endKeyword;
    }

    @Override
    public List<InterfaceDeclarationTree> generics() {
        if (this.genericClause != null) {
            return this.genericClause.generics().interfaces();
        }
        return new ArrayList<InterfaceDeclarationTree>();
    }

    @Override
    public List<InterfaceDeclarationTree> ports() {
        if (this.portClause != null) {
            return this.portClause.ports().interfaces();
        }
        return new ArrayList<InterfaceDeclarationTree>();
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(Collections.singleton(this.componentKeyword), Collections.singleton(this.identifier), this.isKeyword != null ? Collections.singleton(this.isKeyword) : Collections.emptyList(), this.genericClause != null ? Collections.singleton(this.genericClause) : Collections.emptyList(), this.portClause != null ? Collections.singleton(this.portClause) : Collections.emptyList(), Collections.singleton(this.endKeyword), Collections.singleton(this.endComponentKeyword), this.endIdentifier != null ? Collections.singleton(this.endIdentifier) : Collections.emptyList(), Collections.singleton(this.semiPunc));
    }

    @Override
    public String humanReadableKind() {
        return "component";
    }
}

