/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.AttributeSpecificationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConfigurationDeclarativeItemTree;
import com.lintyservices.sonar.plugins.vhdl.parser.GroupDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.UseClauseTree;
import com.lintyservices.utils.LintyException;
import java.util.Collections;

public class ConfigurationDeclarativeItemTreeImpl
extends TreeImpl
implements ConfigurationDeclarativeItemTree {
    private UseClauseTree useClause = null;
    private AttributeSpecificationTree attributeSpecification = null;
    private GroupDeclarationTree groupDeclaration = null;

    public ConfigurationDeclarativeItemTreeImpl(VhdlTree tree) {
        super(VhdlTree.Kind.CONFIGURATION_DECLARATIVE_ITEM);
        if (tree.is(VhdlTree.Kind.USE_CLAUSE)) {
            this.useClause = (UseClauseTree)tree;
        } else if (tree.is(VhdlTree.Kind.ATTRIBUTE_SPECIFICATION)) {
            this.attributeSpecification = (AttributeSpecificationTree)tree;
        } else if (tree.is(VhdlTree.Kind.GROUP_DECLARATION)) {
            this.groupDeclaration = (GroupDeclarationTree)tree;
        } else {
            throw new LintyException("Wrong configuration item kind");
        }
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitConfigurationDeclarativeItem(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.CONFIGURATION_DECLARATIVE_ITEM;
    }

    @Override
    public UseClauseTree useClause() {
        return this.useClause;
    }

    @Override
    public AttributeSpecificationTree attributeSpecification() {
        return this.attributeSpecification;
    }

    @Override
    public GroupDeclarationTree groupDeclaration() {
        return this.groupDeclaration;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        if (this.useClause != null) {
            return Iterables.concat(new Iterable[]{Collections.singleton(this.useClause)});
        }
        if (this.attributeSpecification != null) {
            return Iterables.concat(new Iterable[]{Collections.singleton(this.attributeSpecification)});
        }
        return Iterables.concat(new Iterable[]{Collections.singleton(this.groupDeclaration)});
    }
}

