/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.BlockConfigurationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentConfigurationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConfigurationItemTree;
import java.util.Collections;

public class ConfigurationItemTreeImpl
extends TreeImpl
implements ConfigurationItemTree {
    BlockConfigurationTree blockConfiguration = null;
    ComponentConfigurationTree componentConfiguration = null;

    public ConfigurationItemTreeImpl(VhdlTree tree) {
        super(VhdlTree.Kind.CONFIGURATION_ITEM);
        if (tree.is(VhdlTree.Kind.BLOCK_CONFIGURATION)) {
            this.blockConfiguration = (BlockConfigurationTree)tree;
        } else if (tree.is(VhdlTree.Kind.COMPONENT_CONFIGURATION)) {
            this.componentConfiguration = (ComponentConfigurationTree)tree;
        } else {
            throw new RuntimeException("Wrong configuration item kind");
        }
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitConfigurationItem(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.CONFIGURATION_ITEM;
    }

    @Override
    public BlockConfigurationTree blockConfiguration() {
        return this.blockConfiguration;
    }

    @Override
    public ComponentConfigurationTree componentConfiguration() {
        return this.componentConfiguration;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        if (this.blockConfiguration != null) {
            return Iterables.concat(new Iterable[]{Collections.singleton(this.blockConfiguration)});
        }
        return Iterables.concat(new Iterable[]{Collections.singleton(this.componentConfiguration)});
    }
}

