/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDesignatorTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityNameListTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EntityNameListTreeImpl
extends TreeImpl
implements EntityNameListTree {
    List<EntityDesignatorTree> listDesignators = Collections.emptyList();
    List<VhdlInternalSyntaxToken> listCommas = Collections.emptyList();
    VhdlInternalSyntaxToken othersToken;
    VhdlInternalSyntaxToken allToken;

    public EntityNameListTreeImpl(List<EntityDesignatorTree> designators, List<VhdlInternalSyntaxToken> listCommas) {
        super(VhdlTree.Kind.ENTITY_NAME_LIST);
        this.listDesignators = designators;
        this.listCommas = listCommas;
    }

    public EntityNameListTreeImpl(VhdlInternalSyntaxToken token) {
        super(VhdlTree.Kind.ENTITY_NAME_LIST);
        if (token.getGrammarRuleKey() == VhdlKeyword.OTHERS) {
            this.othersToken = token;
        } else if (token.getGrammarRuleKey() == VhdlKeyword.ALL) {
            this.allToken = token;
        } else {
            throw new IllegalArgumentException(token.getGrammarRuleKey().toString());
        }
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitEntityNameList(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.ENTITY_NAME_LIST;
    }

    @Override
    public List<EntityDesignatorTree> designators() {
        return this.listDesignators;
    }

    @Override
    public boolean isOthers() {
        return this.othersToken != null;
    }

    @Override
    public boolean isAll() {
        return this.allToken != null;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        ArrayList<VhdlTree> result = new ArrayList<VhdlTree>();
        for (int i = 0; i < this.listDesignators.size(); ++i) {
            result.add(this.listDesignators.get(i));
            if (this.listCommas.size() <= i) continue;
            result.add(this.listCommas.get(i));
        }
        if (this.othersToken != null) {
            result.add(this.othersToken);
        }
        if (this.allToken != null) {
            result.add(this.allToken);
        }
        return result;
    }
}

