/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.ExternalNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import java.util.Collections;

public class ExternalNameTreeImpl
extends TreeImpl
implements ExternalNameTree {
    VhdlInternalSyntaxToken sl;
    VhdlInternalSyntaxToken externalType;
    VhdlInternalSyntaxToken namePrefix;
    NameTree name;
    VhdlInternalSyntaxToken colon;
    SubtypeIndicationTree subtypeInd;
    VhdlInternalSyntaxToken sr;
    boolean isConstant = false;
    boolean isVariable = false;
    boolean isSignal = false;

    public ExternalNameTreeImpl(VhdlInternalSyntaxToken sl, VhdlInternalSyntaxToken externalType, VhdlInternalSyntaxToken namePrefix, NameTree name, VhdlInternalSyntaxToken colon, SubtypeIndicationTree subtypeInd, VhdlInternalSyntaxToken sr) {
        super(VhdlTree.Kind.EXTERNAL_NAME);
        this.sl = sl;
        this.externalType = externalType;
        this.namePrefix = namePrefix;
        this.name = name;
        this.colon = colon;
        this.subtypeInd = subtypeInd;
        this.sr = sr;
        if (externalType.toString().equalsIgnoreCase("constant")) {
            this.isConstant = true;
        } else if (externalType.toString().equalsIgnoreCase("variable")) {
            this.isVariable = true;
        } else {
            this.isSignal = true;
        }
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitExternalName(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.EXTERNAL_NAME;
    }

    @Override
    public boolean isConstant() {
        return this.isConstant;
    }

    @Override
    public boolean isVariable() {
        return this.isVariable;
    }

    @Override
    public boolean isSignal() {
        return this.isSignal;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(Collections.singleton(this.sl), Collections.singleton(this.externalType), this.namePrefix != null ? Collections.singleton(this.namePrefix) : Collections.emptyList(), Collections.singleton(this.name), Collections.singleton(this.colon), Collections.singleton(this.subtypeInd), Collections.singleton(this.sr));
    }

    @Override
    public IdentifierTree identifier() {
        return new IdentifierTreeImpl(this.name.firstToken());
    }
}

