/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.BlockDeclarativeItemTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConcurrentStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.GenerateStatementBodyBlockTree;
import com.lintyservices.sonar.plugins.vhdl.parser.GenerateStatementBodyTree;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class GenerateStatementBodyTreeImpl
extends TreeImpl
implements GenerateStatementBodyTree {
    private final List<BlockDeclarativeItemTree> declarativeItems;
    private final List<ConcurrentStatementTree> statements;
    @Nullable
    private GenerateStatementBodyBlockTree block;

    public GenerateStatementBodyTreeImpl(List<BlockDeclarativeItemTree> declarativeItems, List<ConcurrentStatementTree> statements) {
        super(VhdlTree.Kind.GENERATE_STATEMENT_BODY);
        this.declarativeItems = declarativeItems;
        this.statements = statements;
    }

    public GenerateStatementBodyTreeImpl(List<BlockDeclarativeItemTree> declarativeItems, GenerateStatementBodyBlockTree block) {
        super(VhdlTree.Kind.GENERATE_STATEMENT_BODY);
        this.declarativeItems = declarativeItems;
        this.block = block;
        this.statements = block.statements();
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitGenerateStatementBody(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.GENERATE_STATEMENT_BODY;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(this.declarativeItems, this.block != null ? Collections.singleton(this.block) : Collections.emptyList(), this.block == null ? this.statements : Collections.emptyList());
    }

    @Override
    public List<BlockDeclarativeItemTree> declarativeItems() {
        return this.declarativeItems;
    }

    @Override
    public List<ConcurrentStatementTree> statements() {
        return this.statements;
    }

    @Override
    @Nullable
    public GenerateStatementBodyBlockTree block() {
        return this.block;
    }
}

