/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.SyntacticEquivalence;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.IndexedNameExpressionsTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IndexedNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PrefixTree;
import java.util.Collections;
import java.util.List;

public class IndexedNameTreeImpl
extends TreeImpl
implements IndexedNameTree {
    PrefixTree prefix;
    List<IndexedNameExpressionsTree> expressions;

    public IndexedNameTreeImpl(PrefixTree prefix, List<IndexedNameExpressionsTree> expressions) {
        super(VhdlTree.Kind.INDEXED_NAME);
        this.prefix = prefix;
        this.expressions = expressions;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitIndexedName(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.INDEXED_NAME;
    }

    @Override
    public PrefixTree prefix() {
        return this.prefix;
    }

    @Override
    public List<IndexedNameExpressionsTree> expressions() {
        return this.expressions;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(Collections.singleton(this.prefix), this.expressions);
    }

    @Override
    public boolean equals(Object nameTree) {
        if (nameTree instanceof NameTree) {
            return SyntacticEquivalence.areEquivalent((VhdlTree)this, (VhdlTree)nameTree);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.line();
    }
}

