/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierListTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceVariableDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import java.util.Collections;
import java.util.List;

public class InterfaceVariableDeclarationTreeImpl
extends TreeImpl
implements InterfaceVariableDeclarationTree {
    private final VhdlInternalSyntaxToken variableToken;
    private final IdentifierListTree identifierList;
    private final VhdlInternalSyntaxToken colonToken;
    private final VhdlInternalSyntaxToken mode;
    private final SubtypeIndicationTree subtypeIndication;
    private final VhdlInternalSyntaxToken assignToken;
    private final VhdlTree expression;

    public InterfaceVariableDeclarationTreeImpl(VhdlInternalSyntaxToken varToken, IdentifierListTree identifierList, VhdlInternalSyntaxToken colonToken, VhdlInternalSyntaxToken modeToken, SubtypeIndicationTree subtype, VhdlInternalSyntaxToken assignToken, VhdlTree expression) {
        super(VhdlTree.Kind.INTERFACE_VARIABLE_DECLARATION);
        this.variableToken = varToken;
        this.identifierList = identifierList;
        this.colonToken = colonToken;
        this.mode = modeToken;
        this.subtypeIndication = subtype;
        this.assignToken = assignToken;
        this.expression = expression;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitDeclaration(this);
        visitor.visitInterfaceVariableDeclaration(this);
        visitor.leaveDeclaration(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.INTERFACE_VARIABLE_DECLARATION;
    }

    @Override
    public VhdlInternalSyntaxToken mode() {
        return this.mode;
    }

    @Override
    public List<IdentifierTree> identifiers() {
        return this.identifierList.identifierList();
    }

    @Override
    public SubtypeIndicationTree type() {
        return this.subtypeIndication;
    }

    @Override
    public VhdlTree expression() {
        return this.expression;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(this.variableToken != null ? Collections.singleton(this.variableToken) : Collections.emptyList(), Collections.singleton(this.identifierList), Collections.singleton(this.colonToken), this.mode != null ? Collections.singleton(this.mode) : Collections.emptyList(), Collections.singleton(this.subtypeIndication), this.assignToken != null ? Collections.singleton(this.assignToken) : Collections.emptyList(), this.expression != null ? Collections.singleton(this.expression) : Collections.emptyList());
    }

    @Override
    public String humanReadableKind() {
        return "interface variable";
    }
}

