/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierListTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.LibraryClauseTree;
import java.util.Collections;
import java.util.List;

public class LibraryClauseTreeImpl
extends TreeImpl
implements LibraryClauseTree {
    private final VhdlInternalSyntaxToken libraryToken;
    private final IdentifierListTree identifierList;
    private final VhdlInternalSyntaxToken semiPunc;

    public LibraryClauseTreeImpl(VhdlInternalSyntaxToken library, IdentifierListTree idList, VhdlInternalSyntaxToken semiPunc) {
        super(VhdlTree.Kind.LIBRARY_CLAUSE);
        this.libraryToken = library;
        this.identifierList = idList;
        this.semiPunc = semiPunc;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitLibraryClause(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.LIBRARY_CLAUSE;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(Collections.singleton(this.libraryToken), Collections.singleton(this.identifierList), Collections.singleton(this.semiPunc));
    }

    @Override
    public List<IdentifierTree> identifiers() {
        return this.identifierList.identifierList();
    }
}

