/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstantDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarativeItemTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationFunctionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationProcedureTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.VariableDeclarationTree;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class PackageDeclarationTreeImpl
extends TreeImpl
implements PackageDeclarationTree {
    private final VhdlInternalSyntaxToken beginPackageKeyword;
    private final IdentifierTree identifier;
    private final VhdlInternalSyntaxToken isKeyword;
    private final List<PackageDeclarativeItemTree> declarativeItems;
    private final VhdlInternalSyntaxToken endKeyword;
    private final VhdlInternalSyntaxToken endPackageKeyword;
    @Nullable
    private final IdentifierTree endIdentifier;
    @Nullable
    private final VhdlInternalSyntaxToken semicolon;
    private final Set<ConstantDeclarationTree> constants;
    private final Set<ConstantDeclarationTree> deferredConstants;
    private final Set<SubtypeDeclarationTree> subtypes;
    private final Set<FullTypeDeclarationTree> types;
    private final Set<SubprogramSpecificationFunctionTree> functions;
    private final Set<SubprogramSpecificationProcedureTree> procedures;
    private final Set<SignalDeclarationTree> signals;
    private final Set<VariableDeclarationTree> variables;
    private final Set<ComponentDeclarationTree> components;

    public PackageDeclarationTreeImpl(VhdlInternalSyntaxToken beginPackageKeyword, IdentifierTree identifier, VhdlInternalSyntaxToken isKeyword, List<PackageDeclarativeItemTree> packageDeclarativePart, VhdlInternalSyntaxToken endKeyword, VhdlInternalSyntaxToken endPackageKeyword, @Nullable IdentifierTree endIdentifier, @Nullable VhdlInternalSyntaxToken semicolon) {
        super(VhdlTree.Kind.PACKAGE_DECLARATION);
        this.beginPackageKeyword = beginPackageKeyword;
        this.identifier = identifier;
        this.isKeyword = isKeyword;
        this.declarativeItems = packageDeclarativePart;
        this.endKeyword = endKeyword;
        this.endPackageKeyword = endPackageKeyword;
        this.endIdentifier = endIdentifier;
        this.semicolon = semicolon;
        this.constants = this.declarativeItems.stream().filter(t -> t.is(VhdlTree.Kind.CONSTANT_DECLARATION)).map(ConstantDeclarationTree.class::cast).collect(Collectors.toSet());
        this.deferredConstants = this.constants.stream().filter(t -> t.expression() == null).collect(Collectors.toSet());
        this.types = this.declarativeItems.stream().filter(t -> t.is(VhdlTree.Kind.FULL_TYPE_DECLARATION)).map(FullTypeDeclarationTree.class::cast).collect(Collectors.toSet());
        this.subtypes = this.declarativeItems.stream().filter(t -> t.is(VhdlTree.Kind.SUBTYPE_DECLARATION)).map(SubtypeDeclarationTree.class::cast).collect(Collectors.toSet());
        this.functions = this.declarativeItems.stream().filter(t -> t.is(VhdlTree.Kind.SUBPROGRAM_DECLARATION)).map(SubprogramDeclarationTree.class::cast).filter(t -> t.specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_FUNCTION)).map(t -> (SubprogramSpecificationFunctionTree)t.specification()).collect(Collectors.toSet());
        this.procedures = this.declarativeItems.stream().filter(t -> t.is(VhdlTree.Kind.SUBPROGRAM_DECLARATION)).map(SubprogramDeclarationTree.class::cast).filter(t -> t.specification().is(VhdlTree.Kind.SUBPROGRAM_SPECIFICATION_PROCEDURE)).map(t -> (SubprogramSpecificationProcedureTree)t.specification()).collect(Collectors.toSet());
        this.signals = this.declarativeItems.stream().filter(t -> t.is(VhdlTree.Kind.SIGNAL_DECLARATION)).map(SignalDeclarationTree.class::cast).collect(Collectors.toSet());
        this.variables = this.declarativeItems.stream().filter(t -> t.is(VhdlTree.Kind.VARIABLE_DECLARATION)).map(VariableDeclarationTree.class::cast).collect(Collectors.toSet());
        this.components = this.declarativeItems.stream().filter(t -> t.is(VhdlTree.Kind.COMPONENT_DECLARATION)).map(ComponentDeclarationTree.class::cast).collect(Collectors.toSet());
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitDeclaration(this);
        visitor.visitPackageDeclaration(this);
        visitor.leaveDeclaration(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.PACKAGE_DECLARATION;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(Collections.singleton(this.beginPackageKeyword), Collections.singleton(this.identifier), Collections.singleton(this.isKeyword), this.declarativeItems, Collections.singleton(this.endKeyword), this.endPackageKeyword != null ? Collections.singleton(this.endPackageKeyword) : Collections.emptyList(), this.endIdentifier != null ? Collections.singleton(this.endIdentifier) : Collections.emptyList(), Collections.singleton(this.semicolon));
    }

    @Override
    public VhdlInternalSyntaxToken beginPackageKeyword() {
        return this.beginPackageKeyword;
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    public List<PackageDeclarativeItemTree> declarativeItems() {
        return this.declarativeItems;
    }

    @Override
    @Nullable
    public IdentifierTree endIdentifier() {
        return this.endIdentifier;
    }

    @Override
    @Nullable
    public VhdlInternalSyntaxToken endKeyword() {
        return this.endKeyword;
    }

    @Override
    public Set<ConstantDeclarationTree> deferredConstants() {
        return this.deferredConstants;
    }

    @Override
    public Set<ConstantDeclarationTree> constants() {
        return this.constants;
    }

    @Override
    public Set<FullTypeDeclarationTree> types() {
        return this.types;
    }

    @Override
    public Set<SubtypeDeclarationTree> subtypes() {
        return this.subtypes;
    }

    @Override
    public Set<SubprogramSpecificationFunctionTree> functions() {
        return this.functions;
    }

    @Override
    public Set<SubprogramSpecificationProcedureTree> procedures() {
        return this.procedures;
    }

    @Override
    public Set<SignalDeclarationTree> signals() {
        return this.signals;
    }

    @Override
    public Set<VariableDeclarationTree> variables() {
        return this.variables;
    }

    @Override
    public Set<ComponentDeclarationTree> components() {
        return this.components;
    }

    @Override
    public String humanReadableKind() {
        return "package";
    }
}

