/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceListTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PortClauseTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class PortClauseTreeImpl
extends TreeImpl
implements PortClauseTree {
    private final VhdlInternalSyntaxToken portKeyword;
    private final VhdlInternalSyntaxToken lparToken;
    private final InterfaceListTree ports;
    private final VhdlInternalSyntaxToken rparToken;
    private final VhdlInternalSyntaxToken semiPunc;

    public PortClauseTreeImpl(VhdlInternalSyntaxToken portKeyword, VhdlInternalSyntaxToken lparToken, InterfaceListTree ports, VhdlInternalSyntaxToken rparToken, VhdlInternalSyntaxToken semiPunc) {
        super(VhdlTree.Kind.PORT_CLAUSE);
        this.portKeyword = portKeyword;
        this.lparToken = lparToken;
        this.ports = ports;
        this.rparToken = rparToken;
        this.semiPunc = semiPunc;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitPortClause(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.PORT_CLAUSE;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(Collections.singleton(this.portKeyword), Collections.singleton(this.lparToken), Collections.singleton(this.ports), Collections.singleton(this.rparToken), Collections.singleton(this.semiPunc));
    }

    @Override
    public VhdlInternalSyntaxToken portKeyword() {
        return this.portKeyword;
    }

    @Override
    public VhdlInternalSyntaxToken openingParenthesis() {
        return this.lparToken;
    }

    @Override
    public VhdlInternalSyntaxToken closingParenthesis() {
        return this.rparToken;
    }

    @Override
    public InterfaceListTree ports() {
        return this.ports;
    }

    @Override
    public List<IdentifierTree> identifiers() {
        return this.identifiers(Set.of());
    }

    @Override
    public List<IdentifierTree> identifiers(@Nullable Set<String> mode) {
        ArrayList<IdentifierTree> identifiers = new ArrayList<IdentifierTree>();
        for (InterfaceDeclarationTree tree : this.ports.interfaces()) {
            if (mode == null) {
                if (tree.mode() != null) continue;
                identifiers.addAll(tree.identifiers());
                continue;
            }
            if (!mode.isEmpty() && (tree.mode() == null || !mode.contains(tree.mode().text().toLowerCase()))) continue;
            identifiers.addAll(tree.identifiers());
        }
        return identifiers;
    }

    @Override
    public String humanReadableKind() {
        return "port";
    }
}

