/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierColonTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessDeclarativePartTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementPartTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SensitivityListTree;
import com.sonar.sslr.api.typed.Optional;
import java.util.Collections;
import javax.annotation.Nullable;

public class ProcessStatementTreeImpl
extends TreeImpl
implements ProcessStatementTree {
    @Nullable
    private final IdentifierColonTree label;
    @Nullable
    private final VhdlInternalSyntaxToken beginPostponedKeyword;
    private final VhdlInternalSyntaxToken beginStatementKeyword;
    private final VhdlTree sensitivity;
    @Nullable
    private final VhdlInternalSyntaxToken isKeyword;
    @Nullable
    private final ProcessDeclarativePartTree declarativePart;
    private final VhdlInternalSyntaxToken beginKeyword;
    private final ProcessStatementPartTree statementPart;
    private final VhdlInternalSyntaxToken endKeyword;
    @Nullable
    private final VhdlInternalSyntaxToken endPostponedKeyword;
    private final VhdlInternalSyntaxToken endStatementKeyword;
    @Nullable
    private final IdentifierTree endLabel;
    private final VhdlInternalSyntaxToken semicolon;

    public ProcessStatementTreeImpl(@Nullable IdentifierColonTree label, Optional<VhdlInternalSyntaxToken> beginPostponedKeyword, VhdlInternalSyntaxToken beginStatementKeyword, VhdlTree sensitivity, Optional<VhdlInternalSyntaxToken> isKeyword, Optional<ProcessDeclarativePartTree> declarativePartTree, VhdlInternalSyntaxToken beginKeyword, ProcessStatementPartTree statementPart, VhdlInternalSyntaxToken endKeyword, Optional<VhdlInternalSyntaxToken> endPostponedKeyword, VhdlInternalSyntaxToken endStatementKeyword, Optional<VhdlInternalSyntaxToken> endLabel, VhdlInternalSyntaxToken semicolon) {
        super(VhdlTree.Kind.PROCESS_STATEMENT);
        this.label = label;
        this.beginPostponedKeyword = beginPostponedKeyword.isPresent() ? beginPostponedKeyword.get() : null;
        this.beginStatementKeyword = beginStatementKeyword;
        this.sensitivity = sensitivity;
        this.isKeyword = isKeyword.isPresent() ? isKeyword.get() : null;
        this.declarativePart = declarativePartTree.isPresent() ? declarativePartTree.get() : null;
        this.beginKeyword = beginKeyword;
        this.statementPart = statementPart;
        this.endKeyword = endKeyword;
        this.endPostponedKeyword = endPostponedKeyword.isPresent() ? endPostponedKeyword.get() : null;
        this.endStatementKeyword = endStatementKeyword;
        this.endLabel = endLabel.isPresent() ? new IdentifierTreeImpl(endLabel.get()) : null;
        this.semicolon = semicolon;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitProcessStatement(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.PROCESS_STATEMENT;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(this.label != null ? Collections.singleton(this.label) : Collections.emptyList(), this.beginPostponedKeyword != null ? Collections.singleton(this.beginPostponedKeyword) : Collections.emptyList(), Collections.singleton(this.beginStatementKeyword), this.sensitivity != null ? Collections.singleton(this.sensitivity) : Collections.emptyList(), this.isKeyword != null ? Collections.singleton(this.isKeyword) : Collections.emptyList(), this.declarativePart != null ? Collections.singleton(this.declarativePart) : Collections.emptyList(), Collections.singleton(this.beginKeyword), Collections.singleton(this.statementPart), Collections.singleton(this.endKeyword), this.endPostponedKeyword != null ? Collections.singleton(this.endPostponedKeyword) : Collections.emptyList(), Collections.singleton(this.endStatementKeyword), this.endLabel != null ? Collections.singleton(this.endLabel) : Collections.emptyList(), Collections.singleton(this.semicolon));
    }

    @Override
    public VhdlInternalSyntaxToken beginStatementKeyword() {
        return this.beginStatementKeyword;
    }

    @Override
    public VhdlInternalSyntaxToken endKeyword() {
        return this.endKeyword;
    }

    @Override
    @Nullable
    public VhdlInternalSyntaxToken endStatementKeyword() {
        return this.endStatementKeyword;
    }

    @Override
    @Nullable
    public VhdlInternalSyntaxToken isKeyword() {
        return this.isKeyword;
    }

    @Override
    @Nullable
    public IdentifierColonTree label() {
        return this.label;
    }

    @Override
    @Nullable
    public IdentifierTree endLabel() {
        return this.endLabel;
    }

    @Override
    @Nullable
    public SensitivityListTree sensitivity() {
        if (this.sensitivity != null && this.sensitivity.is(VhdlTree.Kind.SENSITIVITY_LIST)) {
            return (SensitivityListTree)this.sensitivity;
        }
        return null;
    }

    @Override
    public boolean hasAllAsSensitivity() {
        return this.sensitivity != null && !this.sensitivity.is(VhdlTree.Kind.SENSITIVITY_LIST);
    }

    @Override
    public ProcessDeclarativePartTree declarativePart() {
        return this.declarativePart;
    }

    @Override
    public ProcessStatementPartTree statementPart() {
        return this.statementPart;
    }
}

