/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.SyntacticEquivalence;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PrefixTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SelectedNameTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SelectedNameTreeImpl
extends TreeImpl
implements SelectedNameTree {
    private final List<VhdlTree> allPrefixes;
    private final List<PrefixTree> prefixes;
    private final VhdlTree suffix;

    public SelectedNameTreeImpl(List<VhdlTree> prefixTrees, VhdlTree suffix) {
        super(VhdlTree.Kind.SELECTED_NAME);
        this.allPrefixes = prefixTrees;
        ArrayList<PrefixTree> pref = new ArrayList<PrefixTree>();
        int inc = 0;
        for (VhdlTree tree : prefixTrees) {
            if (inc % 2 == 0) {
                pref.add((PrefixTree)tree);
            }
            ++inc;
        }
        this.prefixes = pref;
        this.suffix = suffix;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitSelectedName(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.SELECTED_NAME;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(this.allPrefixes, Collections.singletonList(this.suffix));
    }

    @Override
    public List<PrefixTree> prefix() {
        return this.prefixes;
    }

    @Override
    public VhdlTree suffix() {
        return this.suffix;
    }

    @Override
    public boolean equals(Object nameTree) {
        if (nameTree instanceof NameTree) {
            return SyntacticEquivalence.areEquivalent((VhdlTree)this, (VhdlTree)nameTree);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.line();
    }
}

