/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.SyntacticEquivalence;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.DiscreteRangeTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PrefixTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SliceNameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.TreeFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SliceNameTreeImpl
extends TreeImpl
implements SliceNameTree {
    PrefixTree prefix;
    List<TreeFactory.Triplet<VhdlInternalSyntaxToken, DiscreteRangeTree, VhdlInternalSyntaxToken>> ranges;

    public SliceNameTreeImpl(PrefixTree prefix, List<TreeFactory.Triplet<VhdlInternalSyntaxToken, DiscreteRangeTree, VhdlInternalSyntaxToken>> ranges) {
        super(VhdlTree.Kind.SLICE_NAME);
        this.prefix = prefix;
        this.ranges = ranges;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitSliceName(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.SLICE_NAME;
    }

    @Override
    public PrefixTree prefix() {
        return this.prefix;
    }

    @Override
    public List<DiscreteRangeTree> discreteRanges() {
        ArrayList<DiscreteRangeTree> rangesList = new ArrayList<DiscreteRangeTree>();
        this.ranges.forEach(o -> rangesList.add((DiscreteRangeTree)o.second()));
        return rangesList;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        ArrayList rangesList = new ArrayList();
        this.ranges.forEach(o -> {
            rangesList.add((VhdlTree)o.first());
            rangesList.add((VhdlTree)o.second());
            rangesList.add((VhdlTree)o.third());
        });
        return Iterables.concat(Collections.singleton(this.prefix), rangesList);
    }

    @Override
    public boolean equals(Object nameTree) {
        if (nameTree instanceof NameTree) {
            return SyntacticEquivalence.areEquivalent((VhdlTree)this, (VhdlTree)nameTree);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.line();
    }
}

