/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import java.util.Collections;
import java.util.List;

public class SubtypeDeclarationTreeImpl
extends TreeImpl
implements SubtypeDeclarationTree {
    private final VhdlInternalSyntaxToken subtypeKeyword;
    private final IdentifierTree identifier;
    private final VhdlInternalSyntaxToken isKeyword;
    private final VhdlInternalSyntaxToken lpar;
    private final List<NameTree> resolutionList;
    private final VhdlInternalSyntaxToken rpar;
    private final SubtypeIndicationTree subtypeIndication;
    private final VhdlInternalSyntaxToken semiPunc;

    public SubtypeDeclarationTreeImpl(VhdlInternalSyntaxToken subtypeKeyword, IdentifierTree identifier, VhdlInternalSyntaxToken isKeyword, VhdlInternalSyntaxToken lpar, List<NameTree> resolutionList, VhdlInternalSyntaxToken rpar, SubtypeIndicationTree subtypeIndication, VhdlInternalSyntaxToken semiPunc) {
        super(VhdlTree.Kind.SUBTYPE_DECLARATION);
        this.subtypeKeyword = subtypeKeyword;
        this.identifier = identifier;
        this.isKeyword = isKeyword;
        this.lpar = lpar;
        this.resolutionList = resolutionList;
        this.rpar = rpar;
        this.subtypeIndication = subtypeIndication;
        this.semiPunc = semiPunc;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitDeclaration(this);
        visitor.visitSubtypeDeclaration(this);
        visitor.leaveDeclaration(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.SUBTYPE_DECLARATION;
    }

    @Override
    public VhdlSyntaxToken subtypeKeyword() {
        return this.subtypeKeyword;
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    public List<NameTree> resolutionList() {
        return this.resolutionList;
    }

    @Override
    public SubtypeIndicationTree subtypeIndication() {
        return this.subtypeIndication;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        boolean hasResolution = this.lpar != null;
        return Iterables.concat(Collections.singleton(this.subtypeKeyword), Collections.singleton(this.identifier), Collections.singleton(this.isKeyword), hasResolution ? Collections.singleton(this.lpar) : Collections.emptyList(), hasResolution ? this.resolutionList : Collections.emptyList(), hasResolution ? Collections.singleton(this.rpar) : Collections.emptyList(), Collections.singleton(this.subtypeIndication), Collections.singleton(this.semiPunc));
    }

    @Override
    public String humanReadableKind() {
        return "subtype";
    }
}

