/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstraintTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import java.util.Collections;
import java.util.List;

public class SubtypeIndicationTreeImpl
extends TreeImpl
implements SubtypeIndicationTree {
    private final NameTree functionName;
    private final NameTree typeName;
    private final List<ConstraintTree> constraint;

    public SubtypeIndicationTreeImpl(NameTree functionName, NameTree typeName, List<ConstraintTree> constraint) {
        super(VhdlTree.Kind.SUBTYPE_INDICATION);
        this.functionName = functionName;
        this.typeName = typeName;
        this.constraint = constraint;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitSubtypeIndication(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.SUBTYPE_INDICATION;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(this.functionName != null ? Collections.singleton(this.functionName) : Collections.emptyList(), Collections.singleton(this.typeName), this.constraint != null ? this.constraint : Collections.emptyList());
    }

    @Override
    public NameTree typeName() {
        return this.typeName;
    }

    @Override
    public NameTree functionName() {
        return this.functionName;
    }

    @Override
    public List<ConstraintTree> constraint() {
        return this.constraint;
    }
}

