/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.visitors;

import com.lintyservices.sonar.plugins.bugfinder.SynthesizedObjectsManagerInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderSynthesizedObjectsManagerOptionalAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.VhdlSynthesizedObjectsManager;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ElseGenerateStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ElsifGenerateStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.GenerateCaseStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfGenerateStatementTree;
import javax.annotation.Nullable;

public class VhdlSynthesizedVisitor
extends DoubleDispatchVisitor
implements BugFinderSynthesizedObjectsManagerOptionalAwareVisitor {
    @Nullable
    private VhdlSynthesizedObjectsManager synthesizedObjectsManager;

    @Override
    public void setSynthesizedObjectsManager(SynthesizedObjectsManagerInterface synthesizedObjectsManager) {
        this.synthesizedObjectsManager = (VhdlSynthesizedObjectsManager)synthesizedObjectsManager;
    }

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.synthesizedObjectsManager != null && this.context().isSynthesisFile()) {
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitEntityDeclaration(EntityDeclarationTree tree) {
        if (!this.synthesizedObjectsManager.isEntitySynthesized(this.context().file(), tree)) {
            this.setNonSynthesized(tree);
        } else {
            super.visitEntityDeclaration(tree);
        }
    }

    @Override
    public void visitArchitectureBody(ArchitectureBodyTree tree) {
        if (!this.synthesizedObjectsManager.isArchitectureSynthesized(this.context().file(), tree)) {
            this.setNonSynthesized(tree);
        } else {
            super.visitArchitectureBody(tree);
        }
    }

    @Override
    public void visitElseGenerateStatement(ElseGenerateStatementTree tree) {
        if (!this.synthesizedObjectsManager.isBlockSynthesized(this.context().file(), tree)) {
            this.setNonSynthesized(tree);
        } else {
            super.visitElseGenerateStatement(tree);
        }
    }

    @Override
    public void visitElsifGenerateStatement(ElsifGenerateStatementTree tree) {
        if (!this.synthesizedObjectsManager.isBlockSynthesized(this.context().file(), tree)) {
            this.setNonSynthesized(tree);
        } else {
            super.visitElsifGenerateStatement(tree);
        }
    }

    @Override
    public void visitIfGenerateStatement(IfGenerateStatementTree tree) {
        if (!this.synthesizedObjectsManager.isBlockSynthesized(this.context().file(), tree)) {
            for (VhdlTree token : tree.allChildren(VhdlTree.Kind.TOKEN)) {
                if (token.hasAncestor(VhdlTree.Kind.ELSE_GENERATE_STATEMENT) || token.hasAncestor(VhdlTree.Kind.ELSIF_GENERATE_STATEMENT)) continue;
                this.setNonSynthesized((VhdlInternalSyntaxToken)token);
            }
            if (tree.elseStatement() != null) {
                this.visitElseGenerateStatement(tree.elseStatement());
            }
            for (ElsifGenerateStatementTree elsifGenerateStatementTree : tree.elsifStatements()) {
                this.visitElsifGenerateStatement(elsifGenerateStatementTree);
            }
        } else {
            super.visitIfGenerateStatement(tree);
        }
    }

    @Override
    public void visitGenerateCaseStatement(GenerateCaseStatementTree tree) {
        if (!this.synthesizedObjectsManager.isBlockSynthesized(this.context().file(), tree)) {
            this.setNonSynthesized(tree);
        } else {
            super.visitGenerateCaseStatement(tree);
        }
    }

    private void setNonSynthesized(VhdlTree tree) {
        for (VhdlTree token : tree.allChildren(VhdlTree.Kind.TOKEN)) {
            ((VhdlInternalSyntaxToken)token).setSynthesized(false);
        }
    }

    private void setNonSynthesized(VhdlInternalSyntaxToken token) {
        token.setSynthesized(false);
    }
}

