/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.yosys.helpers.clock.ClockDirection;
import com.lintyservices.yosys.objects.YosysClockOrResetDomain;
import com.lintyservices.yosys.objects.YosysFlipFlop;
import com.lintyservices.yosys.objects.YosysScope;
import com.lintyservices.yosys.objects.YosysScopes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class YosysClockDomain
extends YosysClockOrResetDomain {
    private final boolean rising;
    private final boolean falling;
    private final Set<YosysFlipFlop> risingFFs = this.usedInFFs().stream().filter(f -> f.clockDomainUsage().direction() == ClockDirection.RISING).collect(Collectors.toSet());
    private final Set<YosysFlipFlop> fallingFFs = this.usedInFFs().stream().filter(f -> f.clockDomainUsage().direction() == ClockDirection.FALLING).collect(Collectors.toSet());
    private final List<YosysScopes> usedInInstancesFalling;
    private final List<YosysScopes> usedInInstancesRising;

    public YosysClockDomain(Map<String, Object> json, String yosysBuildDir) {
        super(json, yosysBuildDir);
        this.rising = !this.risingFFs.isEmpty();
        this.falling = !this.fallingFFs.isEmpty();
        this.usedInInstancesFalling = json.get("used_in_instances_falling") != null ? ((List)json.get("used_in_instances_falling")).stream().map(scopes -> new YosysScopes(((List)scopes).stream().map(scope -> new YosysScope((Map<String, Object>)scope, yosysBuildDir)).collect(Collectors.toList()))).toList() : new ArrayList<YosysScopes>();
        this.usedInInstancesRising = json.get("used_in_instances_rising") != null ? ((List)json.get("used_in_instances_rising")).stream().map(scopes -> new YosysScopes(((List)scopes).stream().map(scope -> new YosysScope((Map<String, Object>)scope, yosysBuildDir)).collect(Collectors.toList()))).toList() : new ArrayList<YosysScopes>();
    }

    public Set<YosysFlipFlop> risingFFs() {
        return this.risingFFs;
    }

    public Set<YosysFlipFlop> fallingFFs() {
        return this.fallingFFs;
    }

    public boolean rising() {
        return this.rising;
    }

    public boolean falling() {
        return this.falling;
    }

    public List<YosysScopes> usedInInstancesFalling() {
        return this.usedInInstancesFalling;
    }

    public List<YosysScopes> usedInInstancesRising() {
        return this.usedInInstancesRising;
    }
}

