/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.helpers.clock.ClockCellType;
import com.lintyservices.yosys.helpers.clock.ClockDirection;
import com.lintyservices.yosys.interfaces.YosysLocationInterface;
import com.lintyservices.yosys.interfaces.YosysModuleInterface;
import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysModule;
import com.lintyservices.yosys.objects.YosysSignal;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class YosysClockUsage
implements YosysObject,
YosysModuleInterface,
YosysLocationInterface {
    private final String name;
    private final ClockDirection direction;
    private final ClockCellType cellType;
    private final YosysModule module;
    @Nullable
    private final YosysLocation location;
    private final List<YosysSignal> sourceSignals;

    public YosysClockUsage(Map<String, Object> json, String yosysBuildDir) {
        String cellType;
        this.name = (String)json.get("name");
        this.direction = (Boolean)json.get("polarity") != false ? ClockDirection.RISING : ClockDirection.FALLING;
        switch (cellType = (String)json.get("cell_type")) {
            case "flip_flop": {
                this.cellType = ClockCellType.FLIP_FLOP;
                break;
            }
            case "memory": {
                this.cellType = ClockCellType.MEMORY;
                break;
            }
            default: {
                throw new LintyException("Unknown clock cell type: " + cellType);
            }
        }
        this.module = new YosysModule((Map)json.get("module"), yosysBuildDir);
        Map yosysLocation = (Map)json.get("location");
        this.location = !yosysLocation.isEmpty() ? new YosysLocation(yosysLocation, yosysBuildDir) : null;
        this.sourceSignals = ((List)json.get("source_signals")).stream().map(s -> new YosysSignal((Map<String, Object>)s, yosysBuildDir)).toList();
    }

    public String name() {
        return this.name;
    }

    public ClockDirection direction() {
        return this.direction;
    }

    public ClockCellType cellType() {
        return this.cellType;
    }

    @Override
    public YosysModule module() {
        return this.module;
    }

    @Override
    @Nullable
    public YosysLocation location() {
        return this.location;
    }

    public List<YosysSignal> sourceSignals() {
        return this.sourceSignals;
    }
}

