/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.yosys.interfaces.YosysObject;
import java.util.Map;
import java.util.Set;

public class YosysCustomMetrics
implements YosysObject {
    private static final Set<String> FF_CELLS = Set.of("$ff", "$dff", "$dffe", "$dffsr", "$dffsre", "$adff", "$adffe", "$sdff", "$sdffe", "$sdffce", "$aldff", "$aldffe");
    private static final Set<String> FF_CELLS_TO_IGNORE = Set.of("$assert", "$memrd", "$memwr");
    private final int publicWires;
    private final int publicWireBits;
    private final int wires;
    private final int wireBits;
    private final int memories;
    private final int memoryBits;
    private final int flipFlopCells;
    private final int nonFlipFlopCells;
    private final int cells;

    public YosysCustomMetrics(Map<String, Object> json) {
        Map metrics = (Map)json.get("design");
        this.publicWires = (Integer)metrics.get("num_pub_wires");
        this.publicWireBits = (Integer)metrics.get("num_pub_wire_bits");
        this.wires = (Integer)metrics.get("num_wires");
        this.wireBits = (Integer)metrics.get("num_wire_bits");
        this.memories = (Integer)metrics.get("num_memories");
        this.memoryBits = (Integer)metrics.get("num_memory_bits");
        int cells = (Integer)metrics.get("num_cells");
        int flipFlopCells = 0;
        int nonFlipFlopCells = 0;
        Map cellsByType = (Map)metrics.get("num_cells_by_type");
        for (Map.Entry cellType : cellsByType.entrySet()) {
            if (FF_CELLS.contains(cellType.getKey())) {
                flipFlopCells += ((Integer)cellType.getValue()).intValue();
                continue;
            }
            if (!FF_CELLS_TO_IGNORE.contains(cellType.getKey())) {
                nonFlipFlopCells += ((Integer)cellType.getValue()).intValue();
                continue;
            }
            cells -= ((Integer)cellType.getValue()).intValue();
        }
        this.cells = cells;
        this.flipFlopCells = flipFlopCells;
        this.nonFlipFlopCells = nonFlipFlopCells;
    }

    public int publicWires() {
        return this.publicWires;
    }

    public int publicWireBits() {
        return this.publicWireBits;
    }

    public int wires() {
        return this.wires;
    }

    public int wireBits() {
        return this.wireBits;
    }

    public int memories() {
        return this.memories;
    }

    public int memoryBits() {
        return this.memoryBits;
    }

    public int flipFlopCells() {
        return this.flipFlopCells;
    }

    public int nonFlipFlopCells() {
        return this.nonFlipFlopCells;
    }

    public int cells() {
        return this.cells;
    }
}

