/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.interfaces.YosysLocationInterface;
import com.lintyservices.yosys.interfaces.YosysModuleInterface;
import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.YosysFsmTransition;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysModule;
import com.lintyservices.yosys.objects.YosysSignal;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class YosysFsm
implements YosysObject,
YosysModuleInterface,
YosysLocationInterface {
    private final int id;
    private final String name;
    private final String shortName;
    private final YosysModule module;
    @Nullable
    private final YosysLocation location;
    private final List<List<YosysSignal>> inputSignals;
    private final Set<YosysSignal> outputSignals;
    private final Set<YosysFsmTransition> transitions;
    private final Map<String, String> encodedStates;
    private final int numberOfStates;
    @Nullable
    private final String resetState;

    public YosysFsm(Map<String, Object> json, String yosysBuildDir) {
        this.id = (Integer)json.get("id");
        String sname = this.name = (String)json.get("name");
        if (this.name.contains(".")) {
            String[] splitName = this.name.split("\\.");
            sname = splitName[splitName.length - 1];
        }
        this.shortName = sname.split("\\[")[0];
        this.module = new YosysModule((Map)json.get("module"), yosysBuildDir);
        this.numberOfStates = (Integer)json.get("number_of_states");
        List inputs = (List)json.get("input_signals");
        this.inputSignals = new ArrayList<List<YosysSignal>>();
        for (List inputList : inputs) {
            this.inputSignals.add(inputList.stream().map(o -> new YosysSignal((Map<String, Object>)o, yosysBuildDir)).toList());
        }
        List outputs = (List)json.get("output_signals");
        this.outputSignals = outputs.stream().map(o -> new YosysSignal((Map<String, Object>)o, yosysBuildDir)).collect(Collectors.toSet());
        List tr = (List)json.get("transitions");
        this.transitions = tr.stream().map(YosysFsmTransition::new).collect(Collectors.toSet());
        Map yosysLocation = (Map)json.get("location");
        this.location = !yosysLocation.isEmpty() ? new YosysLocation(yosysLocation, yosysBuildDir) : null;
        List es = (List)json.get("encoded_states");
        this.encodedStates = new HashMap<String, String>();
        es.forEach(s -> this.encodedStates.put(((String)s.get("encoded")).substring("enum_value_".length()), StringUtils.stripStart((String)s.get("name"), "\\")));
        String unprocessedResetState = (String)json.get("reset_state");
        if ("".equals(unprocessedResetState)) {
            this.resetState = null;
        } else {
            String trimmedResetState = unprocessedResetState;
            if (trimmedResetState.length() > 1 && trimmedResetState.charAt(1) == '\'') {
                trimmedResetState = unprocessedResetState.substring(2);
            }
            this.resetState = this.encodedStates.isEmpty() ? trimmedResetState : this.encodedStates.get(trimmedResetState);
        }
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String shortName() {
        return this.shortName;
    }

    @Override
    public YosysModule module() {
        return this.module;
    }

    @Override
    @Nullable
    public YosysLocation location() {
        return this.location;
    }

    public Map<String, String> encodedStates() {
        return this.encodedStates;
    }

    public List<String> states() {
        HashSet<String> states = new HashSet<String>();
        if (this.encodedStates.isEmpty()) {
            for (YosysFsmTransition transition : this.transitions) {
                states.add(transition.from());
                states.add(transition.to());
            }
        } else {
            states.addAll(this.encodedStates.values());
        }
        return states.stream().sorted().toList();
    }

    public List<List<YosysSignal>> inputSignals() {
        return this.inputSignals;
    }

    public Set<YosysSignal> outputSignals() {
        return this.outputSignals;
    }

    public Set<YosysFsmTransition> transitions() {
        return this.transitions;
    }

    public int numberOfStates() {
        return this.numberOfStates;
    }

    @Nullable
    public String resetState() {
        return this.resetState;
    }

    public boolean belongsToFile(File file) {
        return this.location != null && FileUtils.equals(this.location.file(), file);
    }
}

