/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.yosys.helpers.reset.ResetPolarity;
import com.lintyservices.yosys.helpers.reset.ResetType;
import com.lintyservices.yosys.objects.YosysClockOrResetDomain;
import com.lintyservices.yosys.objects.YosysFlipFlop;
import com.lintyservices.yosys.objects.YosysScope;
import com.lintyservices.yosys.objects.YosysScopes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class YosysResetDomain
extends YosysClockOrResetDomain {
    @Nullable
    private final Boolean global;
    private final boolean asynchronous;
    private final boolean synchronous;
    private final boolean activeHigh;
    private final boolean activeLow;
    private final Set<YosysFlipFlop> asynchronousFFs;
    private final Set<YosysFlipFlop> synchronousFFs;
    private final Set<YosysFlipFlop> activeHighFFs;
    private final Set<YosysFlipFlop> activeLowFFs;
    private final List<YosysScopes> usedInInstancesAsynchronousActiveLow;
    private final List<YosysScopes> usedInInstancesAsynchronousActiveHigh;
    private final List<YosysScopes> usedInInstancesSynchronousActiveLow;
    private final List<YosysScopes> usedInInstancesSynchronousActiveHigh;
    private final List<YosysScopes> usedInInstances;

    public YosysResetDomain(Map<String, Object> json, String yosysBuildDir) {
        super(json, yosysBuildDir);
        this.global = (Boolean)json.get("global");
        this.asynchronousFFs = this.usedInFFs().stream().filter(f -> f.resetDomainUsage().type() == ResetType.ASYNCHRONOUS).collect(Collectors.toSet());
        this.synchronousFFs = this.usedInFFs().stream().filter(f -> f.resetDomainUsage().type() == ResetType.SYNCHRONOUS).collect(Collectors.toSet());
        this.activeHighFFs = this.usedInFFs().stream().filter(f -> f.resetDomainUsage().polarity() == ResetPolarity.ACTIVE_HIGH).collect(Collectors.toSet());
        this.activeLowFFs = this.usedInFFs().stream().filter(f -> f.resetDomainUsage().polarity() == ResetPolarity.ACTIVE_LOW).collect(Collectors.toSet());
        this.asynchronous = !this.asynchronousFFs.isEmpty();
        this.synchronous = !this.synchronousFFs.isEmpty();
        this.activeHigh = !this.activeHighFFs.isEmpty();
        this.activeLow = !this.activeLowFFs.isEmpty();
        this.usedInInstancesAsynchronousActiveLow = json.get("used_in_instances_asynchronous_active_low") != null ? ((List)json.get("used_in_instances_asynchronous_active_low")).stream().map(scopes -> new YosysScopes(((List)scopes).stream().map(scope -> new YosysScope((Map<String, Object>)scope, yosysBuildDir)).collect(Collectors.toList()))).toList() : new ArrayList<YosysScopes>();
        this.usedInInstancesAsynchronousActiveHigh = json.get("used_in_instances_asynchronous_active_high") != null ? ((List)json.get("used_in_instances_asynchronous_active_high")).stream().map(scopes -> new YosysScopes(((List)scopes).stream().map(scope -> new YosysScope((Map<String, Object>)scope, yosysBuildDir)).collect(Collectors.toList()))).toList() : new ArrayList<YosysScopes>();
        this.usedInInstancesSynchronousActiveLow = json.get("used_in_instances_synchronous_active_low") != null ? ((List)json.get("used_in_instances_synchronous_active_low")).stream().map(scopes -> new YosysScopes(((List)scopes).stream().map(scope -> new YosysScope((Map<String, Object>)scope, yosysBuildDir)).collect(Collectors.toList()))).toList() : new ArrayList<YosysScopes>();
        this.usedInInstancesSynchronousActiveHigh = json.get("used_in_instances_synchronous_active_high") != null ? ((List)json.get("used_in_instances_synchronous_active_high")).stream().map(scopes -> new YosysScopes(((List)scopes).stream().map(scope -> new YosysScope((Map<String, Object>)scope, yosysBuildDir)).collect(Collectors.toList()))).toList() : new ArrayList<YosysScopes>();
        this.usedInInstances = new ArrayList<YosysScopes>();
        this.usedInInstances.addAll(this.usedInInstancesAsynchronousActiveLow);
        this.usedInInstances.addAll(this.usedInInstancesAsynchronousActiveHigh);
        this.usedInInstances.addAll(this.usedInInstancesSynchronousActiveLow);
        this.usedInInstances.addAll(this.usedInInstancesSynchronousActiveHigh);
    }

    @Nullable
    public Boolean global() {
        return this.global;
    }

    @Nullable
    public Boolean local() {
        return this.global == false;
    }

    public Set<YosysFlipFlop> activeLowFFs() {
        return this.activeLowFFs;
    }

    public Set<YosysFlipFlop> activeHighFFs() {
        return this.activeHighFFs;
    }

    public Set<YosysFlipFlop> synchronousFFs() {
        return this.synchronousFFs;
    }

    public Set<YosysFlipFlop> asynchronousFFs() {
        return this.asynchronousFFs;
    }

    public boolean activeLow() {
        return this.activeLow;
    }

    public boolean activeHigh() {
        return this.activeHigh;
    }

    public boolean synchronous() {
        return this.synchronous;
    }

    public boolean asynchronous() {
        return this.asynchronous;
    }

    public List<YosysScopes> usedInInstancesAsynchronousActiveLow() {
        return this.usedInInstancesAsynchronousActiveLow;
    }

    public List<YosysScopes> usedInInstancesAsynchronousActiveHigh() {
        return this.usedInInstancesAsynchronousActiveHigh;
    }

    public List<YosysScopes> usedInInstancesSynchronousActiveLow() {
        return this.usedInInstancesSynchronousActiveLow;
    }

    public List<YosysScopes> usedInInstancesSynchronousActiveHigh() {
        return this.usedInInstancesSynchronousActiveHigh;
    }

    public List<YosysScopes> usedInInstances() {
        return this.usedInInstances;
    }
}

