/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.profiles;

import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractor;
import com.optimaize.langdetect.profiles.LanguageProfile;
import com.optimaize.langdetect.profiles.LanguageProfileImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LanguageProfileBuilder {
    @NotNull
    private final LdLocale locale;
    private int minimalFrequency = 1;
    private NgramExtractor ngramExtractor;
    private final Map<Integer, Map<String, Integer>> ngrams = new HashMap<Integer, Map<String, Integer>>();

    public LanguageProfileBuilder(@NotNull LdLocale locale) {
        this.locale = locale;
    }

    @Deprecated
    public LanguageProfileBuilder(@NotNull String locale) {
        this.locale = LdLocale.fromString(locale);
    }

    public LanguageProfileBuilder ngramExtractor(@NotNull NgramExtractor ngramExtractor) {
        this.ngramExtractor = ngramExtractor;
        return this;
    }

    public LanguageProfileBuilder minimalFrequency(int minimalFrequency) {
        if (minimalFrequency < 1) {
            throw new IllegalArgumentException("minimalFrequency must be >= 1, but was: " + minimalFrequency);
        }
        this.minimalFrequency = minimalFrequency;
        return this;
    }

    public LanguageProfileBuilder addText(CharSequence text) {
        if (this.ngramExtractor == null) {
            throw new IllegalStateException("NgramExtractor has not been set yet!");
        }
        for (Map.Entry<String, Integer> entry : this.ngramExtractor.extractCountedGrams(text).entrySet()) {
            this.addGram(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public LanguageProfileBuilder addGram(String ngram) {
        return this.addGram(ngram, 1);
    }

    public LanguageProfileBuilder addGram(String ngram, int frequency) {
        Integer total;
        Map<String, Integer> map = this.ngrams.get(ngram.length());
        if (map == null) {
            map = new HashMap<String, Integer>();
            this.ngrams.put(ngram.length(), map);
        }
        if ((total = map.get(ngram)) == null) {
            total = 0;
        }
        total = total + frequency;
        map.put(ngram, total);
        return this;
    }

    public LanguageProfile build() {
        if (this.minimalFrequency > 1) {
            this.removeNgramsWithLessFrequency();
        }
        return new LanguageProfileImpl(this.locale, this.ngrams);
    }

    private void removeNgramsWithLessFrequency() {
        for (Map<String, Integer> map : this.ngrams.values()) {
            Iterator<Map.Entry<String, Integer>> iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Integer> next = iterator2.next();
                if (next.getValue() >= this.minimalFrequency) continue;
                iterator2.remove();
            }
        }
    }
}

