/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.github.configuration;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.stream.Collectors;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.PatchRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;
import org.sonarqube.ws.client.github.configuration.GithubConfiguration;

public class GithubConfigurationService
extends BaseService {
    public GithubConfigurationService(WsConnector wsConnector) {
        super(wsConnector, "api/v2/dop-translation/github-configurations");
    }

    public String saveGithubConfiguration(GithubConfiguration config) {
        String body = String.format("{\n  \"enabled\": \"%s\",\n  \"clientId\": \"%s\",\n  \"clientSecret\": \"%s\",\n  \"applicationId\": \"%s\",\n  \"privateKey\": \"%s\",\n  \"synchronizeGroups\": \"%s\",\n  \"apiUrl\": \"%s\",\n  \"webUrl\": \"%s\",\n  \"allowedOrganizations\": [\"%s\"],\n  \"provisioningType\": \"%s\",\n  \"allowUsersToSignUp\": \"%s\",\n  \"projectVisibility\": \"%s\",\n  \"userConsentRequiredAfterUpgrade\": \"%s\"\n}\n", config.enabled(), config.clientId(), config.clientSecret(), config.applicationId(), GithubConfigurationService.escapeNewLineChars(config.privateKey()), config.synchronizeGroups(), config.apiUrl(), config.webUrl(), config.allowedOrganizations().stream().map(Object::toString).collect(Collectors.joining("\", \"")), config.provisioningType(), config.allowUsersToSignUp(), config.provisionProjectVisibility(), config.userConsentRequiredAfterUpgrade());
        WsResponse response = this.call((WsRequest)new PostRequest(this.path()).setBody(body));
        return new Gson().fromJson(response.content(), JsonObject.class).get("id").getAsString();
    }

    private static String escapeNewLineChars(String key) {
        return key.replace("\n", "\\n");
    }

    public void enableAutoProvisioning(String configId) {
        this.setProvisioningMode(configId, "AUTO_PROVISIONING");
    }

    public void disableAutoProvisioning(String configId) {
        this.setProvisioningMode(configId, "JIT");
    }

    private void setProvisioningMode(String configId, String provisioningMode) {
        String body = String.format("{\n  \"provisioningType\": \"%s\"\n}\n", provisioningMode);
        this.call((WsRequest)((PatchRequest)new PatchRequest(this.path(configId)).setBody(body)).setContentType("application/merge-patch+json"));
    }
}

