/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.modelsim;

import java.io.File;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.utils.ParsingUtils;

public class ModelSimReportParser {
    private final SensorContext context;
    private String additionalReportType;

    private ModelSimReportParser(SensorContext context) {
        this.context = context;
    }

    public static void parseReport(File xmlFile, SensorContext context, String mode) {
        new ModelSimReportParser(context).parse(xmlFile, mode);
    }

    private void parse(File xmlFile, String additionalReportType) {
        this.additionalReportType = additionalReportType;
        try {
            SMInputFactory inputFactory = ModelSimReportParser.initStax();
            SMHierarchicCursor rootCursor = inputFactory.rootElementCursor(xmlFile);
            while (rootCursor.getNext() != null) {
                this.collectReportMeasures(rootCursor.descendantElementCursor("code_coverage_report"));
            }
            rootCursor.getStreamReader().closeCompletely();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("XML is not valid", e);
        }
    }

    private static SMInputFactory initStax() {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return new SMInputFactory(xmlFactory);
    }

    private void collectReportMeasures(SMInputCursor report) throws XMLStreamException {
        while (report.getNext() != null) {
            this.collectFileMeasures(report.descendantElementCursor("fileData"));
        }
    }

    private boolean resourceExists(InputFile file) {
        return file != null && this.context.fileSystem().inputFile(this.context.fileSystem().predicates().is(file.file())) != null;
    }

    private void collectFileMeasures(SMInputCursor clazz) throws XMLStreamException {
        while (clazz.getNext() != null) {
            String path = clazz.getAttrValue("path");
            this.collectFileData(clazz, path);
        }
    }

    private void collectFileData(SMInputCursor clazz, String path) throws XMLStreamException {
        InputFile resource = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasPath(path));
        NewCoverage coverage = null;
        boolean lineAdded = false;
        if (this.resourceExists(resource)) {
            coverage = this.context.newCoverage();
            coverage.onFile(resource);
        }
        SMInputCursor element = clazz.childCursor();
        while (element.getNext() != null) {
            String name = null;
            try {
                name = element.getPrefixedName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ("condition".equalsIgnoreCase(this.additionalReportType) && "condition".equalsIgnoreCase(name)) {
                try {
                    if (coverage == null) continue;
                    int ln = Integer.parseInt(element.getAttrValue("ln"));
                    coverage.lineHits(ln, 1);
                    coverage.conditions(ln, Integer.parseInt(element.getAttrValue("active")), Integer.parseInt(element.getAttrValue("hits")));
                    lineAdded = true;
                }
                catch (Exception ln) {}
                continue;
            }
            if ("branch".equalsIgnoreCase(this.additionalReportType) && ("case".equalsIgnoreCase(name) || "if".equalsIgnoreCase(name))) {
                try {
                    int active = Integer.parseInt(element.getAttrValue("active"));
                    int hits = Integer.parseInt(element.getAttrValue("hits"));
                    if (coverage == null) continue;
                    SMInputCursor child = element.childCursor();
                    child.getNext();
                    child.getNext();
                    int ln = Integer.parseInt(child.getAttrValue("ln"));
                    coverage.lineHits(ln, 1);
                    coverage.conditions(ln, active, hits);
                    lineAdded = true;
                }
                catch (Exception active) {}
                continue;
            }
            if (!"stmt".equalsIgnoreCase(name)) continue;
            try {
                int ln = Integer.parseInt(element.getAttrValue("ln"));
                if (coverage == null) continue;
                coverage.lineHits(ln, (int)ParsingUtils.parseNumber((String)element.getAttrValue("hits")));
                lineAdded = true;
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
        if (coverage != null) {
            if (!lineAdded) {
                coverage.lineHits(1, 1);
            }
            coverage.save();
        }
    }
}

