/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.modelsim;

import com.lintyservices.sonar.plugins.modelsim.ModelSimReportParser;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class ModelSimSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(ModelSimSensor.class);
    private final FileSystem fs;
    private final PathResolver pathResolver;
    private final Configuration configuration;

    public ModelSimSensor(FileSystem fs, PathResolver pathResolver, Configuration configuration) {
        this.fs = fs;
        this.pathResolver = pathResolver;
        this.configuration = configuration;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("ModelSimSensor");
    }

    public void execute(SensorContext context) {
        Set<File> reportFiles = this.reportFiles();
        String mode = this.configuration.get("sonar.modelsim.additionalReportType").orElse(null);
        for (File reportFile : reportFiles) {
            this.parseReport(reportFile, context, mode);
        }
    }

    protected void parseReport(File xmlFile, SensorContext context, String mode) {
        LOG.info("[ModelSim] Parsing {}", (Object)xmlFile);
        ModelSimReportParser.parseReport(xmlFile, context, mode);
    }

    private Set<File> reportFiles() {
        String reportPathsProperty = this.configuration.get("sonar.modelsim.reportPaths").orElse(null);
        Set<Object> reportPaths = new HashSet();
        if (reportPathsProperty != null) {
            reportPaths = Arrays.stream(reportPathsProperty.split(",")).map(String::trim).collect(Collectors.toSet());
        }
        HashSet<File> reportFiles = new HashSet<File>();
        for (String path : reportPaths) {
            File reportFile = this.pathResolver.relativeFile(this.fs.baseDir(), path);
            if (reportFile == null || !reportFile.exists()) {
                LOG.warn("[ModelSim] Cannot find \"{}\" report", (Object)path);
                continue;
            }
            if (!reportFile.canRead()) {
                LOG.warn("[ModelSim] Cannot read \"{}\" report", (Object)path);
                continue;
            }
            if (reportFile.isDirectory()) {
                reportFiles.addAll(Arrays.stream(reportFile.listFiles()).filter(f -> f.isFile() && f.getName().endsWith(".xml")).collect(Collectors.toSet()));
                continue;
            }
            if (!reportFile.isFile()) continue;
            reportFiles.add(reportFile);
        }
        return reportFiles;
    }
}

