/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.license;

import com.lintyservices.sonar.plugins.linty.license.License;
import com.lintyservices.sonar.plugins.linty.license.LicenseCheckerException;
import com.lintyservices.sonar.plugins.linty.license.LicenseWebService;
import javax.annotation.Nullable;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;

public class LicenseChecker {
    private final SensorContext context;
    private final String plugin;
    private final boolean activeBugFinderRules;

    public LicenseChecker(SensorContext context, String plugin, boolean activeBugFinderRules) {
        this.context = context;
        this.plugin = plugin;
        this.activeBugFinderRules = activeBugFinderRules;
    }

    public void check() throws LicenseCheckerException {
        String encodedLicenseKey = this.getEncodedLicenseKey();
        License license = encodedLicenseKey == null ? new License() : new License(encodedLicenseKey);
        LicenseWebService webService = new LicenseWebService(this.getWsClient());
        license.checkAll(this.getServerID(), webService.totalNcloc(this.context.project().key()), this.plugin, this.activeBugFinderRules);
    }

    public void checkFromVsCode() throws LicenseCheckerException {
        String encodedLicenseKey = this.getEncodedLicenseKey();
        License license = encodedLicenseKey == null ? new License() : new License(encodedLicenseKey);
        license.checkFromVsCode(this.getServerID(), this.plugin);
    }

    @Nullable
    private String getServerID() {
        return this.context.config().get("sonar.core.id").orElse(null);
    }

    @Nullable
    private String getEncodedLicenseKey() {
        return this.context.config().get("linty.license").orElse(null);
    }

    private WsClient getWsClient() throws LicenseCheckerException {
        String hostUrl;
        String login;
        if (this.context.config().get("sonar.token").isPresent() && !this.context.config().get("sonar.token").isEmpty()) {
            login = (String)this.context.config().get("sonar.token").get();
        } else if (System.getenv("SONAR_TOKEN") != null && !System.getenv("SONAR_TOKEN").isEmpty()) {
            login = System.getenv("SONAR_TOKEN");
        } else if (this.context.config().get("sonar.login").isPresent() && !this.context.config().get("sonar.login").isEmpty()) {
            login = (String)this.context.config().get("sonar.login").get();
        } else {
            throw new LicenseCheckerException("Mandatory \"sonar.token\" property or \"sonar.login\" property or \"SONAR_TOKEN\" environment variable is not set.");
        }
        if (this.context.config().get("sonar.host.url").isPresent() && !this.context.config().get("sonar.host.url").isEmpty()) {
            hostUrl = (String)this.context.config().get("sonar.host.url").get();
        } else if (System.getenv("SONAR_HOST_URL") != null && !System.getenv("SONAR_HOST_URL").isEmpty()) {
            hostUrl = System.getenv("SONAR_HOST_URL");
        } else {
            throw new LicenseCheckerException("Mandatory \"sonar.host.url\" property or \"SONAR_HOST_URL\" environment variable is not set.");
        }
        return WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(hostUrl).credentials(login, this.context.config().get("sonar.password").orElse("")).build());
    }
}

