/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.license;

import com.google.common.base.Splitter;
import com.lintyservices.sonar.plugins.linty.license.LicenseCheckerException;
import com.lintyservices.sonar.plugins.linty.license.LicenseProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonarqube.ws.Components;
import org.sonarqube.ws.Measures;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.components.SearchRequest;
import org.sonarqube.ws.client.measures.ComponentRequest;

public class LicenseWebService {
    private final WsClient wsClient;

    public LicenseWebService(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public long totalNcloc(String currentlyAnalyzedProjectKey) throws LicenseCheckerException {
        Set<String> projectKeys = this.getAllProjectKeys();
        if (!projectKeys.contains(currentlyAnalyzedProjectKey)) {
            throw new LicenseCheckerException("\"linty-scanner\" user cannot browse currently analyzed project (key=" + currentlyAnalyzedProjectKey + "). Please, update your project permissions.");
        }
        return this.getTotalNcloc(projectKeys);
    }

    private long getTotalNcloc(Set<String> projectKeys) {
        long ncloc = 0L;
        for (String projectKey : projectKeys) {
            Map<String, String> nclocLanguageDistributionByProject = this.getNclocLanguageDistributionByProject(projectKey);
            ncloc += this.getNclocByProject(nclocLanguageDistributionByProject);
        }
        return ncloc;
    }

    private long getNclocByProject(Map<String, String> nclocLanguageDistributionByProject) {
        long ncloc = 0L;
        for (String language : LicenseProperties.LANGUAGES) {
            if (nclocLanguageDistributionByProject.get(language) == null) continue;
            ncloc += Long.parseLong(nclocLanguageDistributionByProject.get(language));
        }
        return ncloc;
    }

    private Map<String, String> getNclocLanguageDistributionByProject(String projectKey) {
        Measures.ComponentWsResponse response = this.wsClient.measures().component(new ComponentRequest().setComponent(projectKey).setMetricKeys(Collections.singletonList("ncloc_language_distribution")));
        List<Measures.Measure> measures = response.getComponent().getMeasuresList();
        Map<String, String> nclocLanguageDistributionByProject = new HashMap<String, String>();
        if (measures.size() == 1) {
            nclocLanguageDistributionByProject = Splitter.on(";").withKeyValueSeparator("=").split(measures.get(0).getValue());
        }
        return nclocLanguageDistributionByProject;
    }

    private Set<String> getAllProjectKeys() {
        HashSet<String> projectKeys = new HashSet<String>();
        Set projectKeysOnCurrentPage = null;
        int page = 1;
        while (projectKeysOnCurrentPage == null || !projectKeysOnCurrentPage.isEmpty()) {
            Components.SearchWsResponse response = this.wsClient.components().search(new SearchRequest().setQualifiers(Collections.singletonList("TRK")).setPs("500").setP(String.valueOf(page)));
            projectKeysOnCurrentPage = response.getComponentsList().stream().map(Components.Component::getKey).collect(Collectors.toSet());
            projectKeys.addAll(projectKeysOnCurrentPage);
            ++page;
        }
        return projectKeys;
    }
}

