/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl;

import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.checks.Checks;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueSaver;
import com.lintyservices.sonar.plugins.linty.language.issues.LineIssue;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueInterface;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.sonar.plugins.linty.license.LicenseChecker;
import com.lintyservices.sonar.plugins.tcl.FileTreeTuple;
import com.lintyservices.sonar.plugins.tcl.Product;
import com.lintyservices.sonar.plugins.tcl.api.TclCheck;
import com.lintyservices.sonar.plugins.tcl.api.TclFileScannerContext;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.checks.CheckList;
import com.lintyservices.sonar.plugins.tcl.checks.active.ParsingErrorCheck;
import com.lintyservices.sonar.plugins.tcl.measures.visitors.MetricsVisitor;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import com.lintyservices.sonar.plugins.tcl.parser.TclParser;
import com.lintyservices.sonar.plugins.tcl.visitors.CpdVisitor;
import com.lintyservices.sonar.plugins.tcl.visitors.SyntaxHighlighterVisitor;
import com.lintyservices.sonar.plugins.tcl.visitors.TreeVisitor;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;

@DependsUpon(value={"license"})
public class TclCodeAnalyzerSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(TclCodeAnalyzerSensor.class);
    private final CheckFactory checkFactory;
    private final Configuration config;
    private final ActionParser<TclTree> parser;
    private final Charset charset;
    private IssueSaver issueSaver;
    private ParsingErrorCheck parsingErrorCheck;
    private final Set<File> filesToAnalyze;
    private final FileSystem fileSystem;

    public TclCodeAnalyzerSensor(FileSystem fileSystem, Configuration config, CheckFactory checkFactory) {
        this.checkFactory = checkFactory;
        this.config = config;
        this.parser = TclParser.createParser(Charset.defaultCharset());
        this.charset = Charset.defaultCharset();
        this.fileSystem = fileSystem;
        this.filesToAnalyze = this.filesToAnalyze();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Tcl Code Analyzer").onlyOnLanguage("tcl");
    }

    public void execute(SensorContext context) {
        Set freeHdlDesignerChecks;
        LOG.info("--- Running Tcl Code Analyzer...");
        boolean hdlDesigner = Product.hdlDesigner(context);
        boolean notHdlDesigner = !hdlDesigner;
        Checks checks = new Checks(this.checkFactory).registerCheckClasses("tcl", CheckList.getChecks());
        List<Check> tclChecks = checks.allChecks().stream().filter(c -> notHdlDesigner || c instanceof HdlDesignerCheck).toList();
        if (hdlDesigner && !(freeHdlDesignerChecks = tclChecks.stream().filter(c -> !(c instanceof FreeHdlDesignerCheck)).collect(Collectors.toSet())).isEmpty()) {
            new LicenseChecker(context, "tcl", false).checkFromVsCode();
        }
        this.issueSaver = new IssueSaver(context, checks, this.filesToAnalyze, this.mainFilesPredicate(), hdlDesigner);
        this.setParsingErrorCheckIfActivated(checks.allChecks());
        List<FileTreeTuple> fileTreeTuples = this.parseFiles();
        this.decorateFiles(fileTreeTuples, this.createDecoratorVisitors(context));
        List<IssueInterface> issues = this.gatherIssues(fileTreeTuples, tclChecks);
        this.saveSingleFileIssues(issues);
    }

    private void decorateFiles(List<FileTreeTuple> fileTreeTuples, List<TreeVisitor> decoratorVisitors) {
        LOG.info("Decorating files...");
        int i = 1;
        int size = this.filesToAnalyze.size();
        for (FileTreeTuple tuple : fileTreeTuples) {
            LOG.info(i + "/" + size + " " + tuple.file().getAbsolutePath());
            this.scanFile(tuple.file(), tuple.tree(), decoratorVisitors);
            ++i;
        }
        LOG.info("Decorating files: Done");
    }

    private List<FileTreeTuple> parseFiles() {
        LOG.info("Parsing files...");
        ArrayList<FileTreeTuple> fileTreeTuples = new ArrayList<FileTreeTuple>();
        int i = 1;
        int size = this.filesToAnalyze.size();
        for (File file : this.filesToAnalyze) {
            LOG.info(i + "/" + size + " " + file.getAbsolutePath());
            FileTreeTuple tuple = this.parseFile(file);
            if (tuple != null) {
                fileTreeTuples.add(tuple);
            }
            ++i;
        }
        LOG.info("Parsing files: Done");
        return fileTreeTuples;
    }

    private List<IssueInterface> gatherIssues(List<FileTreeTuple> fileTreeTuples, List<Check> tclChecks) {
        LOG.info("Analyzing files to gather issues...");
        ArrayList<IssueInterface> issues = new ArrayList<IssueInterface>();
        List<TreeVisitor> checkVisitors = tclChecks.stream().filter(TreeVisitor.class::isInstance).map(c -> (TreeVisitor)((Object)c)).toList();
        int i = 1;
        int size = this.filesToAnalyze.size();
        for (FileTreeTuple tuple : fileTreeTuples) {
            LOG.info(i + "/" + size + " " + tuple.file().getAbsolutePath());
            issues.addAll(this.scanFile(tuple.file(), tuple.tree(), checkVisitors));
            ++i;
        }
        LOG.info("Analyzing files to gather issues: Done");
        return issues;
    }

    private void saveSingleFileIssues(List<IssueInterface> issues) {
        LOG.info("Saving single file issues...");
        this.issueSaver.saveIssues(issues);
        LOG.info("Saving single file issues: Done");
    }

    private FilePredicate mainFilesPredicate() {
        return this.fileSystem.predicates().and(this.fileSystem.predicates().hasType(InputFile.Type.MAIN), this.fileSystem.predicates().hasLanguage("tcl"));
    }

    private Set<File> filesToAnalyze() {
        HashSet<File> files = new HashSet<File>();
        for (InputFile file : this.fileSystem.inputFiles(this.mainFilesPredicate())) {
            files.add(new File(file.uri()));
        }
        return files;
    }

    private List<TreeVisitor> createDecoratorVisitors(SensorContext context) {
        ArrayList<TreeVisitor> visitors = new ArrayList<TreeVisitor>();
        visitors.add(new CpdVisitor(context));
        visitors.add(new SyntaxHighlighterVisitor(context));
        visitors.add(new MetricsVisitor(context));
        return visitors;
    }

    private FileTreeTuple parseFile(File file) {
        try {
            return new FileTreeTuple(file, (ScriptFileTree)this.parser.parse(file));
        }
        catch (RecognitionException e) {
            LOG.error("Unable to parse file: " + file.getAbsolutePath());
            LOG.error(e.getMessage());
            this.createIssueIfParsingErrorCheckIsActivated(e, file);
            return null;
        }
    }

    private List<IssueInterface> scanFile(File file, ScriptFileTree tree, List<TreeVisitor> visitors) {
        TclFileScannerContext context = new TclFileScannerContext(tree, file, this.config);
        ArrayList<IssueInterface> issues = new ArrayList<IssueInterface>();
        for (TreeVisitor visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                CharsetAwareVisitor charsetAwareVisitor = (CharsetAwareVisitor)((Object)visitor);
                charsetAwareVisitor.setCharset(this.charset);
            }
            if (visitor instanceof TclCheck) {
                TclCheck tclCheck = (TclCheck)((Object)visitor);
                issues.addAll(tclCheck.scanFile(context).allIssues());
                continue;
            }
            visitor.scanTree(context);
        }
        return issues;
    }

    private void setParsingErrorCheckIfActivated(List<Check> allChecks) {
        for (Check check2 : allChecks) {
            ParsingErrorCheck errorCheck;
            if (!(check2 instanceof ParsingErrorCheck)) continue;
            this.parsingErrorCheck = errorCheck = (ParsingErrorCheck)check2;
            break;
        }
    }

    private void createIssueIfParsingErrorCheckIsActivated(RecognitionException e, File file) {
        if (this.parsingErrorCheck != null) {
            this.issueSaver.saveIssue(new LineIssue(this.parsingErrorCheck, file, e.getLine(), e.getMessage()));
        }
    }
}

