/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl;

import com.lintyservices.sonar.plugins.linty.language.checks.Checks;
import com.lintyservices.sonar.plugins.tcl.TclCodeAnalyzerSensor;
import com.lintyservices.sonar.plugins.tcl.TclLanguage;
import com.lintyservices.sonar.plugins.tcl.TclProfiles;
import com.lintyservices.sonar.plugins.tcl.TclRulesDefinition;
import com.lintyservices.sonar.plugins.tcl.visitors.CpdVisitor;
import com.lintyservices.utils.LintyException;
import org.sonar.api.Plugin;
import org.sonar.api.config.PropertyDefinition;

public class TclPlugin
implements Plugin {
    public static final String FILE_SUFFIXES_KEY = "sonar.tcl.file.suffixes";
    public static final String DEFAULT_FILE_SUFFIXES = ".tcl";
    private static final String TCL_CATEGORY = "TCL";
    private static final String GENERAL_SUBCATEGORY = "General";
    private static final int SONARQUBE_VERSION_MAJOR = 8;
    private static final int SONARQUBE_VERSION_MINOR = 9;
    private static final String SONARQUBE_VERSION_ERROR = "SonarQube 8.9 or above is required to execute the Linty TCL plugin";

    public void define(Plugin.Context context) {
        if (context.getSonarQubeVersion().major() <= 8 && (context.getSonarQubeVersion().major() != 8 || context.getSonarQubeVersion().minor() < 9)) {
            throw new LintyException(SONARQUBE_VERSION_ERROR);
        }
        context.addExtensions(TclLanguage.class, Checks.class, new Object[]{TclRulesDefinition.class, TclProfiles.class, TclCodeAnalyzerSensor.class, CpdVisitor.class, PropertyDefinition.builder((String)FILE_SUFFIXES_KEY).name("File Suffixes").defaultValue(DEFAULT_FILE_SUFFIXES).category(TCL_CATEGORY).subCategory(GENERAL_SUBCATEGORY).description("List of suffixes for TCL files to analyze. To not filter, leave the list empty.").multiValues(true).onQualifiers("TRK", new String[0]).build()});
    }
}

