/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.api.tree;

import com.google.common.base.Preconditions;
import com.lintyservices.sonar.plugins.tcl.api.TclFileScannerContext;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.BracketsBlockTree;
import com.lintyservices.sonar.plugins.tcl.parser.CommandsAndTerminatorsTree;
import com.lintyservices.sonar.plugins.tcl.parser.CurlyBracesBlockTree;
import com.lintyservices.sonar.plugins.tcl.parser.ExprTree;
import com.lintyservices.sonar.plugins.tcl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.tcl.parser.NameTree;
import com.lintyservices.sonar.plugins.tcl.parser.NamespaceEvalTree;
import com.lintyservices.sonar.plugins.tcl.parser.PackageProvideTree;
import com.lintyservices.sonar.plugins.tcl.parser.ParenthesesBlockTree;
import com.lintyservices.sonar.plugins.tcl.parser.ProcTree;
import com.lintyservices.sonar.plugins.tcl.parser.PutsTree;
import com.lintyservices.sonar.plugins.tcl.parser.RegexpTree;
import com.lintyservices.sonar.plugins.tcl.parser.RegsubTree;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import com.lintyservices.sonar.plugins.tcl.parser.SetTree;
import com.lintyservices.sonar.plugins.tcl.parser.StringTree;
import com.lintyservices.sonar.plugins.tcl.parser.TerminatorTree;
import com.lintyservices.sonar.plugins.tcl.parser.UnknownCommandTree;
import com.lintyservices.sonar.plugins.tcl.parser.VariableInterpolationTree;
import com.lintyservices.sonar.plugins.tcl.parser.VariableTree;
import com.lintyservices.sonar.plugins.tcl.visitors.TreeVisitor;
import java.util.List;
import javax.annotation.Nullable;

public abstract class DoubleDispatchVisitor
implements TreeVisitor {
    private TclFileScannerContext context;

    private void scanChildren(TclTree tree) {
        this.scan(((TreeImpl)tree).getChildren());
    }

    protected void scan(List<? extends TclTree> trees) {
        for (TclTree tclTree : trees) {
            this.scan(tclTree);
        }
    }

    protected void scan(@Nullable TclTree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    @Override
    public final void scanTree(TclFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public TclFileScannerContext getContext() {
        Preconditions.checkState(this.context != null, "this#scanTree(context) should be called to initialised the context before accessing it");
        return this.context;
    }

    public void visitBracketsBlock(BracketsBlockTree tree) {
        this.scanChildren(tree);
    }

    public void visitCommandsAndTerminators(CommandsAndTerminatorsTree tree) {
        this.scanChildren(tree);
    }

    public void visitCurlyBracesBlock(CurlyBracesBlockTree tree) {
        this.scanChildren(tree);
    }

    public void visitExpr(ExprTree tree) {
        this.scanChildren(tree);
    }

    public void visitIdentifier(IdentifierTree tree) {
        this.scanChildren(tree);
    }

    public void visitName(NameTree tree) {
        this.scanChildren(tree);
    }

    public void visitNamespaceEval(NamespaceEvalTree tree) {
        this.scanChildren(tree);
    }

    public void visitPackageProvide(PackageProvideTree tree) {
        this.scanChildren(tree);
    }

    public void visitParenthesesBlock(ParenthesesBlockTree tree) {
        this.scanChildren(tree);
    }

    public void visitProc(ProcTree tree) {
        this.scanChildren(tree);
    }

    public void visitPuts(PutsTree tree) {
        this.scanChildren(tree);
    }

    public void visitRegexp(RegexpTree tree) {
        this.scanChildren(tree);
    }

    public void visitRegsub(RegsubTree tree) {
        this.scanChildren(tree);
    }

    public void visitScriptFile(ScriptFileTree tree) {
        this.scanChildren(tree);
    }

    public void visitSet(SetTree tree) {
        this.scanChildren(tree);
    }

    public void visitString(StringTree tree) {
        this.scanChildren(tree);
    }

    public void visitSyntaxToken(SyntaxToken token) {
        this.scan(token.trivias());
    }

    public void visitSyntaxTrivia(SyntaxTrivia trivia) {
    }

    public void visitTerminator(TerminatorTree tree) {
        this.scanChildren(tree);
    }

    public void visitUnknownCommand(UnknownCommandTree tree) {
        this.scanChildren(tree);
    }

    public void visitVariable(VariableTree tree) {
        this.scanChildren(tree);
    }

    public void visitVariableInterpolation(VariableInterpolationTree tree) {
        this.scanChildren(tree);
    }
}

